/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class J2EEModule {
    private static final StringManager localStrings = StringManager.getManager(J2EEModule.class);
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private String standaloneModuleName = null;
    private String subModuleName = null;
    private ModuleType moduleType = null;
    private String ddLocation = null;

    public J2EEModule() {
    }

    public J2EEModule(String standaloneModuleName) throws ServerInstanceException {
        if (standaloneModuleName == null || standaloneModuleName.length() < 1) {
            sLogger.log(Level.WARNING, this.getLogMsg("invalid standAloneModuleName"));
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.J2EEModule.invalidStandaloneModuleName"));
        }
        this.standaloneModuleName = standaloneModuleName;
    }

    public J2EEModule(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        this(standaloneModuleName);
        if (subModuleName == null || subModuleName.length() < 1) {
            sLogger.log(Level.WARNING, this.getLogMsg("invalid sub module for the given stand-alone module"));
            throw new ServerInstanceException(localStrings.getString("admin.mbeans.J2EEModule.invalidSubModuleName"));
        }
        this.subModuleName = subModuleName;
    }

    public ModuleType getModuleType() throws ServerInstanceException {
        if (this.moduleType != null) {
            return this.moduleType;
        }
        this.moduleType = this.subModuleName == null ? this.getModuleType(this.standaloneModuleName) : this.getModuleType(this.standaloneModuleName, this.subModuleName);
        return this.moduleType;
    }

    public String getDeploymentDescriptorsLocation() throws ServerInstanceException {
        if (this.ddLocation != null) {
            this.ddLocation = RelativePathResolver.resolvePath(this.ddLocation);
            return this.ddLocation;
        }
        this.ddLocation = this.subModuleName == null ? this.getDDLocation(this.standaloneModuleName) : this.getDDLocation(this.standaloneModuleName, this.subModuleName);
        if (this.ddLocation != null) {
            this.ddLocation = RelativePathResolver.resolvePath(this.ddLocation);
        }
        return this.ddLocation;
    }

    ModuleType getModuleType(String standaloneModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getModuleType for standaloneModuleName" + standaloneModuleName));
        ModuleType moduleType = null;
        try {
            Mbean[] mbModules;
            LifecycleModule[] lcModules;
            AppclientModule[] acModules;
            ConnectorModule[] connectorConfigBeans;
            WebModule[] wModules;
            EjbModule[] eModules;
            Applications appsConfigBean = (Applications)ConfigBeansFactory.getConfigBeanByXPath(AdminService.getAdminService().getAdminContext().getAdminConfigContext(), "/domain/applications");
            J2eeApplication[] j2eeApps = appsConfigBean.getJ2eeApplication();
            if (j2eeApps != null) {
                for (int i = 0; i < j2eeApps.length; ++i) {
                    if (!j2eeApps[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = j2eeApps[i].getLocation();
                    return ModuleType.EAR;
                }
            }
            if ((eModules = appsConfigBean.getEjbModule()) != null) {
                for (int i = 0; i < eModules.length; ++i) {
                    if (!eModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = eModules[i].getLocation();
                    return ModuleType.EJB;
                }
            }
            if ((wModules = appsConfigBean.getWebModule()) != null) {
                for (int i = 0; i < wModules.length; ++i) {
                    if (!wModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = wModules[i].getLocation();
                    return ModuleType.WAR;
                }
            }
            if ((connectorConfigBeans = appsConfigBean.getConnectorModule()) != null) {
                for (int i = 0; i < connectorConfigBeans.length; ++i) {
                    if (!connectorConfigBeans[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = connectorConfigBeans[i].getLocation();
                    return ModuleType.RAR;
                }
            }
            if ((acModules = appsConfigBean.getAppclientModule()) != null) {
                for (int i = 0; i < acModules.length; ++i) {
                    if (!acModules[i].getName().equals(standaloneModuleName)) continue;
                    this.ddLocation = acModules[i].getLocation();
                    return ModuleType.CAR;
                }
            }
            if ((lcModules = appsConfigBean.getLifecycleModule()) != null) {
                for (int i = 0; i < lcModules.length; ++i) {
                    if (!lcModules[i].getName().equals(standaloneModuleName)) continue;
                    return XModuleType.LCM;
                }
            }
            if ((mbModules = appsConfigBean.getMbean()) != null) {
                for (int i = 0; i < mbModules.length; ++i) {
                    if (!mbModules[i].getName().equals(standaloneModuleName)) continue;
                    return XModuleType.CMB;
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return moduleType;
    }

    ModuleType getModuleType(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getModuleType standaloneModuleName = " + standaloneModuleName + " " + "subModuleName = " + subModuleName));
        ModuleType moduleType = null;
        try {
            AppsManager am = InstanceFactory.createAppsManager(ApplicationServer.getServerContext().getInstanceName());
            Application appD = (Application)DeploymentUtils.getDescriptor(standaloneModuleName, am);
            BundleDescriptor bd2 = null;
            Set bds = appD.getBundleDescriptors();
            for (BundleDescriptor bd2 : bds) {
                if (!bd2.getModuleDescriptor().getArchiveUri().equals(subModuleName) && !bd2.getModuleID().equals(subModuleName) && !bd2.getName().equals(subModuleName)) continue;
                moduleType = bd2.getModuleType();
                this.ddLocation = am.getLocation(standaloneModuleName) + File.separator + FileUtils.makeFriendlyFileName(bd2.getModuleDescriptor().getArchiveUri());
                break;
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return moduleType;
    }

    String getDDLocation(String standaloneModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getDDLocation for standaloneModuleName " + standaloneModuleName));
        return this.ddLocation;
    }

    String getDDLocation(String standaloneModuleName, String subModuleName) throws ServerInstanceException {
        sLogger.log(Level.FINE, this.getLogMsg("getDDLocation for standaloneModuleName " + standaloneModuleName + " " + "subModuleName = " + subModuleName));
        return this.ddLocation;
    }

    public String getStringForDDxml(String fileName) throws ServerInstanceException {
        try {
            return FileUtils.getFileContents(fileName);
        }
        catch (FileNotFoundException fnfe) {
            sLogger.log(Level.WARNING, this.getLogMsg("getStringForDDxml FileNotFoundException " + fileName));
            throw new ServerInstanceException(fnfe.getLocalizedMessage());
        }
        catch (IOException ioe) {
            sLogger.log(Level.WARNING, this.getLogMsg("getStringForDDxml IOException " + fileName));
            throw new ServerInstanceException(ioe.getLocalizedMessage());
        }
    }

    private String getLogMsg(String str) {
        return this.getClass().getName() + ":" + str;
    }
}

