/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.util.GeneralPatternMatcher;
import com.sun.enterprise.admin.util.IPatternMatcher;
import com.sun.enterprise.admin.util.RegExpMatcher;
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

public class CombinedPatternMatcher
implements IPatternMatcher {
    private String mPattern = null;
    private String mTestString = null;
    private IPatternMatcher mRealMatcher = null;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(CombinedPatternMatcher.class);

    public CombinedPatternMatcher(String patternString, String testString) {
        if (patternString == null || testString == null) {
            String msg = localizedStrMgr.getString("admin.common.combinedpattermatcher_null_arg");
            throw new IllegalArgumentException(msg);
        }
        this.mPattern = patternString;
        this.mTestString = testString;
        if (this.isJDK14()) {
            this.mPattern = this.translateFromJMXToJDK14(patternString);
            this.mRealMatcher = new RegExpMatcher(this.mPattern, testString);
        } else {
            this.mRealMatcher = new GeneralPatternMatcher(patternString, testString);
        }
    }

    public boolean matches() {
        return this.mRealMatcher.matches();
    }

    public boolean isJDK14() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        return javaSpecVersion.startsWith("1.4");
    }

    private String translateFromJMXToJDK14(String aString) {
        String dotEscpapedString = this.escapeDots(aString);
        String starReplacedString = this.insertDotBeforeStar(dotEscpapedString);
        String qmReplacedString = this.insertDotBeforeQM(starReplacedString);
        return qmReplacedString;
    }

    private String escapeDots(String aString) {
        char escape = '\\';
        char dot = '.';
        return this.insertCharBefore(aString, escape, dot);
    }

    private String insertDotBeforeStar(String aString) {
        char dot = '.';
        char star = '*';
        return this.insertCharBefore(aString, dot, star);
    }

    private String insertDotBeforeQM(String aString) {
        char dot = '.';
        char qm = '?';
        return this.insertCharBefore(aString, dot, qm);
    }

    private String insertCharBefore(String aString, char insChar, char beforeChar) {
        StringBuffer destBuffer = new StringBuffer();
        char[] srcArray = aString.toCharArray();
        for (int i = 0; i < srcArray.length; ++i) {
            char ch = srcArray[i];
            if (ch == beforeChar) {
                destBuffer.append(insChar);
            }
            destBuffer.append(ch);
        }
        return destBuffer.toString();
    }
}

