/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.RemoteBusinessIntfInfo;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.WebServiceInvocationHandler;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.spi.stats.StatelessSessionBeanStatsProvider;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.webservice.EjbRuntimeEndpointInfo;
import com.sun.enterprise.webservice.ServiceInterfaceGenerator;
import com.sun.enterprise.webservice.WebServiceEjbEndpointRegistry;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.Transaction;

public final class StatelessSessionContainer
extends BaseContainer
implements StatelessSessionBeanStatsProvider {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings;
    private static final int POOLED = 1;
    private static final int INVOKING = 2;
    private static final int DESTROYED = 3;
    private static final int LOW_WATER_MARK = 100;
    private static final byte[] statelessInstanceKey;
    private Method homeCreateMethod = null;
    private Method localHomeCreateMethod = null;
    private EJBLocalObjectImpl theEJBLocalObjectImpl = null;
    private EJBLocalObjectImpl theEJBLocalBusinessObjectImpl = null;
    private EJBObjectImpl theEJBObjectImpl = null;
    private EJBObject theEJBObject = null;
    private EJBObject theEJBStub = null;
    private EJBObjectImpl theRemoteBusinessObjectImpl = null;
    private Remote theRemoteBusinessObject = null;
    private Map<String, Remote> theRemoteBusinessStubs = new HashMap<String, Remote>();
    private EjbRuntimeEndpointInfo webServiceEndpoint;
    private boolean isPoolClosed = false;
    protected AbstractPool pool;
    private IASEjbExtraDescriptors iased = null;
    private BeanCacheDescriptor beanCacheDes = null;
    private BeanPoolDescriptor beanPoolDes = null;
    private Server svr = null;
    private Config cfg = null;
    private EjbContainer ejbContainer = null;
    private PoolProperties poolProp = null;

    StatelessSessionContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        try {
            if (this.hasLocalHomeView) {
                this.localHomeCreateMethod = this.localHomeIntf.getMethod("create", NO_PARAMS);
            }
            if (this.hasRemoteHomeView) {
                this.homeCreateMethod = this.homeIntf.getMethod("create", NO_PARAMS);
            }
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.get_ejbcreate_method_exception", this.logParams);
                _logger.log(Level.SEVERE, "", ex);
            }
            throw ex;
        }
        EjbSessionDescriptor ed = (EjbSessionDescriptor)desc;
        this.iased = ed.getIASEjbExtraDescriptors();
        if (this.iased != null) {
            this.beanPoolDes = this.iased.getBeanPool();
        }
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            this.cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
        }
        catch (ConfigException ex) {
            ex.printStackTrace();
        }
        this.ejbContainer = this.cfg.getEjbContainer();
        super.setMonitorOn(this.ejbContainer.isMonitoringEnabled());
        super.createCallFlowAgent(ComponentType.SLSB);
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("STATELESS ").append(this.ejbDescriptor.getName());
        sbuf.append(this.pool.getAllAttrValues());
        sbuf.append("]");
        return sbuf.toString();
    }

    protected void initializeHome() throws Exception {
        super.initializeHome();
        if (this.isRemote) {
            if (this.hasRemoteHomeView) {
                this.theEJBObjectImpl = this.instantiateEJBObjectImpl();
                this.theEJBObject = (EJBObject)this.theEJBObjectImpl.getEJBObject();
                this.theEJBStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(statelessInstanceKey);
                this.theEJBObjectImpl.setStub((Remote)this.theEJBStub);
            }
            if (this.hasRemoteBusinessView) {
                this.theRemoteBusinessObjectImpl = this.instantiateRemoteBusinessObjectImpl();
                this.theRemoteBusinessObject = this.theRemoteBusinessObjectImpl.getEJBObject();
                for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                    Remote stub = next.referenceFactory.createRemoteReference(statelessInstanceKey);
                    this.theRemoteBusinessStubs.put(next.generatedRemoteIntf.getName(), stub);
                    this.theRemoteBusinessObjectImpl.setStub(next.generatedRemoteIntf.getName(), stub);
                }
            }
        }
        if (this.isLocal) {
            if (this.hasLocalHomeView) {
                this.theEJBLocalObjectImpl = this.instantiateEJBLocalObjectImpl();
            }
            if (this.hasLocalBusinessView) {
                this.theEJBLocalBusinessObjectImpl = this.instantiateEJBLocalBusinessObjectImpl();
            }
        }
        if (this.isWebServiceEndpoint) {
            ServiceInterfaceGenerator generator;
            EjbBundleDescriptor bundle = this.ejbDescriptor.getEjbBundleDescriptor();
            WebServicesDescriptor webServices = bundle.getWebServices();
            Collection<WebServiceEndpoint> myEndpoints = webServices.getEndpointsImplementedBy(this.ejbDescriptor);
            Long ejbId = new Long(this.ejbDescriptor.getUniqueId());
            Iterator<WebServiceEndpoint> iter = myEndpoints.iterator();
            WebServiceEndpoint next = iter.next();
            Class serviceEndpointIntfClass = this.loader.loadClass(next.getServiceEndpointInterface());
            if (!serviceEndpointIntfClass.isInterface() && (serviceEndpointIntfClass = WsUtil.generateAndLoad(generator = new ServiceInterfaceGenerator(this.loader, this.ejbClass), this.loader)) == null) {
                throw new RuntimeException("Error generating the SEI");
            }
            Class<?> tieClass = null;
            WebServiceInvocationHandler invocationHandler = new WebServiceInvocationHandler(this.ejbClass, next, serviceEndpointIntfClass, this.webServiceInvocationInfoMap);
            invocationHandler.setContainer(this);
            Object servant = Proxy.newProxyInstance(this.loader, new Class[]{serviceEndpointIntfClass}, (InvocationHandler)invocationHandler);
            if (next.getTieClassName() != null) {
                tieClass = this.loader.loadClass(next.getTieClassName());
            }
            this.webServiceEndpoint = WebServiceEjbEndpointRegistry.getRegistry().createEjbEndpointInfo(next, this, servant, tieClass);
            WebServiceEjbEndpointRegistry.getRegistry().registerEjbWebServiceEndpoint(this.webServiceEndpoint);
        }
        SessionContextFactory sessionCtxFactory = new SessionContextFactory();
        this.poolProp = new PoolProperties();
        this.pool = new NonBlockingPool(this.ejbDescriptor.getName(), sessionCtxFactory, this.poolProp.steadyPoolSize, this.poolProp.poolResizeQuantity, this.poolProp.maxPoolSize, this.poolProp.poolIdleTimeoutInSeconds, this.loader);
        this.registerMonitorableComponents();
    }

    protected void registerMonitorableComponents() {
        this.registryMediator.registerProvider(this);
        this.registryMediator.registerProvider(this.pool);
        super.registerMonitorableComponents();
        super.populateMethodMonitorMap();
        _logger.log(Level.FINE, "[SLSB Container] registered monitorable");
    }

    public void onReady() {
    }

    public EJBObjectImpl createRemoteBusinessObjectImpl() throws CreateException, RemoteException {
        ++this.statCreateCount;
        return this.theRemoteBusinessObjectImpl;
    }

    public EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        this.authorizeRemoteMethod(14);
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.homeCreateMethod, null);
        }
        ++this.statCreateCount;
        return this.theEJBObjectImpl;
    }

    public EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        this.authorizeLocalMethod(15);
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.localHomeCreateMethod, null);
        }
        return this.theEJBLocalObjectImpl;
    }

    public EJBLocalObjectImpl createEJBLocalBusinessObjectImpl() throws CreateException {
        return this.theEJBLocalBusinessObjectImpl;
    }

    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        ++this.statRemoveCount;
    }

    void forceDestroyBean(EJBContextImpl sc) {
        if (sc.getState() == 3) {
            return;
        }
        sc.setState(3);
        this.pool.destroyObject(sc);
    }

    EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        return this.theEJBObjectImpl;
    }

    EJBObjectImpl getEJBRemoteBusinessObjectImpl(byte[] instanceKey) {
        return this.theRemoteBusinessObjectImpl;
    }

    EJBLocalObjectImpl getEJBLocalObjectImpl(Object key) {
        return this.theEJBLocalObjectImpl;
    }

    EJBLocalObjectImpl getEJBLocalBusinessObjectImpl(Object key) {
        return this.theEJBLocalBusinessObjectImpl;
    }

    protected ComponentContext _getContext(Invocation inv) {
        try {
            SessionContextImpl sessionCtx = (SessionContextImpl)this.pool.getObject(null);
            sessionCtx.setState(2);
            return sessionCtx;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SessionContextImpl createStatelessEJB() throws CreateException {
        SessionContextImpl context;
        block13: {
            ComponentInvocation ci = null;
            try {
                try {
                    Object ejb = this.ejbClass.newInstance();
                    context = new SessionContextImpl(ejb, this);
                    context.setInterceptorInstances(this.interceptorManager.createInterceptorInstances());
                    ci = new ComponentInvocation(ejb, this, context);
                    this.invocationManager.preInvoke(ci);
                    if (ejb instanceof SessionBean) {
                        ((SessionBean)ejb).setSessionContext((SessionContext)context);
                    }
                    this.injectionManager.injectInstance(ejb, this.ejbDescriptor, false);
                    for (Object interceptorInstance : context.getInterceptorInstances()) {
                        this.injectionManager.injectInstance(interceptorInstance, this.ejbDescriptor, false);
                    }
                    if (this.isRemote) {
                        if (this.hasRemoteHomeView) {
                            context.setEJBObjectImpl(this.theEJBObjectImpl);
                            context.setEJBStub(this.theEJBStub);
                        }
                        if (this.hasRemoteBusinessView) {
                            context.setEJBRemoteBusinessObjectImpl(this.theRemoteBusinessObjectImpl);
                        }
                    }
                    if (this.isLocal) {
                        if (this.hasLocalHomeView) {
                            context.setEJBLocalObjectImpl(this.theEJBLocalObjectImpl);
                        }
                        if (this.hasLocalBusinessView) {
                            context.setEJBLocalBusinessObjectImpl(this.theEJBLocalBusinessObjectImpl);
                        }
                    }
                    context.setInstanceKey(statelessInstanceKey);
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, context);
                    context.setState(1);
                }
                catch (Throwable th) {
                    _logger.log(Level.INFO, "ejb.stateless_ejbcreate_exception", th);
                    CreateException creEx = new CreateException("Could not create stateless EJB");
                    creEx.initCause(th);
                    throw creEx;
                }
                Object var9_10 = null;
                if (ci == null) break block13;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (ci != null) {
                    this.invocationManager.postInvoke(ci);
                }
                throw throwable;
            }
            this.invocationManager.postInvoke(ci);
        }
        context.touch();
        return context;
    }

    void doTimerInvocationInit(Invocation inv, RuntimeTimerState timerState) throws Exception {
        if (this.isRemote) {
            inv.ejbObject = this.theEJBObjectImpl;
            inv.isLocal = false;
        } else {
            inv.ejbObject = this.theEJBLocalObjectImpl;
            inv.isLocal = true;
        }
    }

    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran) {
            if (inv instanceof Invocation) {
                Invocation i = (Invocation)inv;
                EJBContextImpl sc = (EJBContextImpl)i.context;
                utMethodsAllowed = !sc.isInEjbRemove();
            } else {
                utMethodsAllowed = false;
            }
        }
        return utMethodsAllowed;
    }

    public void releaseContext(Invocation inv) {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        if (sc.getState() == 3) {
            return;
        }
        sc.setState(1);
        sc.setTransaction(null);
        sc.touch();
        this.pool.returnObject(sc);
    }

    boolean isIdentical(EJBObjectImpl ejbo, EJBObject other) throws RemoteException {
        if (other == ejbo.getStub()) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical(ejbo.getStub(), (Remote)other);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.ejb_getstub_exception", this.logParams);
                _logger.log(Level.SEVERE, "", ex);
            }
            throw new RemoteException("Error during isIdentical.", ex);
        }
    }

    void checkExists(EJBLocalRemoteObject ejbObj) {
    }

    void afterBegin(EJBContextImpl context) {
    }

    void beforeCompletion(EJBContextImpl context) {
    }

    void afterCompletion(EJBContextImpl ctx, int status) {
    }

    public boolean passivateEJB(ComponentContext context) {
        return false;
    }

    public void activateEJB(Object ctx, Object instanceKey) {
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\nStatelessContainer: ").append("CreateCount=").append(this.statCreateCount).append("; ").append("RemoveCount=").append(this.statRemoveCount).append("; ").append("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        super.setUndeployedState();
        try {
            if (this.isWebServiceEndpoint && this.webServiceEndpoint != null) {
                String endpointAddress = this.webServiceEndpoint.getEndpointAddressUri();
                WebServiceEjbEndpointRegistry.getRegistry().unregisterEjbWebServiceEndpoint(endpointAddress);
            }
            if (this.hasRemoteHomeView) {
                this.remoteHomeRefFactory.destroyReference(this.theEJBObjectImpl.getStub(), this.theEJBObjectImpl.getEJBObject());
            }
            if (this.hasRemoteBusinessView) {
                for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                    next.referenceFactory.destroyReference(this.theRemoteBusinessObjectImpl.getStub(next.generatedRemoteIntf.getName()), this.theRemoteBusinessObjectImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                }
            }
            this.isPoolClosed = true;
            this.pool.close();
            Object var4_3 = null;
            super.undeploy();
            this.homeCreateMethod = null;
            this.localHomeCreateMethod = null;
            this.theEJBLocalObjectImpl = null;
            this.theEJBObjectImpl = null;
            this.theEJBStub = null;
            this.pool = null;
            this.iased = null;
            this.beanCacheDes = null;
            this.beanPoolDes = null;
            this.svr = null;
            this.ejbContainer = null;
            this.poolProp = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            super.undeploy();
            this.homeCreateMethod = null;
            this.localHomeCreateMethod = null;
            this.theEJBLocalObjectImpl = null;
            this.theEJBObjectImpl = null;
            this.theEJBStub = null;
            this.pool = null;
            this.iased = null;
            this.beanCacheDes = null;
            this.beanPoolDes = null;
            this.svr = null;
            this.ejbContainer = null;
            this.poolProp = null;
            throw throwable;
        }
    }

    public long getMethodReadyCount() {
        return this.pool.getSize();
    }

    public int getMaxPoolSize() {
        return this.poolProp.maxPoolSize <= 0 ? Integer.MAX_VALUE : this.poolProp.maxPoolSize;
    }

    public int getSteadyPoolSize() {
        return this.poolProp.steadyPoolSize <= 0 ? 0 : this.poolProp.steadyPoolSize;
    }

    static {
        _logger.log(Level.FINE, " Loading StatelessSessionContainer...");
        localStrings = new LocalStringManagerImpl(StatelessSessionContainer.class);
        statelessInstanceKey = new byte[]{0, 0, 0, 1};
    }

    private class PoolProperties {
        int maxPoolSize;
        int poolIdleTimeoutInSeconds;
        int poolResizeQuantity;
        int steadyPoolSize;

        public PoolProperties() {
            this.maxPoolSize = new Integer(StatelessSessionContainer.this.ejbContainer.getMaxPoolSize());
            this.poolIdleTimeoutInSeconds = new Integer(StatelessSessionContainer.this.ejbContainer.getPoolIdleTimeoutInSeconds());
            this.poolResizeQuantity = new Integer(StatelessSessionContainer.this.ejbContainer.getPoolResizeQuantity());
            this.steadyPoolSize = new Integer(StatelessSessionContainer.this.ejbContainer.getSteadyPoolSize());
            if (StatelessSessionContainer.this.beanPoolDes != null) {
                int temp = 0;
                temp = StatelessSessionContainer.this.beanPoolDes.getMaxPoolSize();
                if (temp != -1) {
                    this.maxPoolSize = temp;
                }
                if ((temp = StatelessSessionContainer.this.beanPoolDes.getPoolIdleTimeoutInSeconds()) != -1) {
                    this.poolIdleTimeoutInSeconds = temp;
                }
                if ((temp = StatelessSessionContainer.this.beanPoolDes.getPoolResizeQuantity()) != -1) {
                    this.poolResizeQuantity = temp;
                }
                if ((temp = StatelessSessionContainer.this.beanPoolDes.getSteadyPoolSize()) != -1) {
                    this.steadyPoolSize = temp;
                }
            }
        }
    }

    private class SessionContextFactory
    implements ObjectFactory {
        private SessionContextFactory() {
        }

        public Object create(Object param) {
            try {
                return StatelessSessionContainer.this.createStatelessEJB();
            }
            catch (CreateException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void destroy(Object obj) {
            SessionContextImpl sessionCtx;
            block12: {
                sessionCtx = (SessionContextImpl)obj;
                Object sb = sessionCtx.getEJB();
                if (sessionCtx.getState() != 3) {
                    sessionCtx.setState(3);
                    Invocation inv = null;
                    try {
                        try {
                            inv = new Invocation(sb, StatelessSessionContainer.this);
                            inv.context = sessionCtx;
                            StatelessSessionContainer.this.invocationManager.preInvoke(inv);
                            sessionCtx.setInEjbRemove(true);
                            StatelessSessionContainer.this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, sessionCtx);
                        }
                        catch (Throwable t) {
                            _logger.log(Level.FINE, "ejbRemove exception", t);
                            Object var7_7 = null;
                            sessionCtx.setInEjbRemove(false);
                            if (inv != null) {
                                StatelessSessionContainer.this.invocationManager.postInvoke(inv);
                            }
                            break block12;
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        sessionCtx.setInEjbRemove(false);
                        if (inv != null) {
                            StatelessSessionContainer.this.invocationManager.postInvoke(inv);
                        }
                        throw throwable;
                    }
                    sessionCtx.setInEjbRemove(false);
                    if (inv != null) {
                        StatelessSessionContainer.this.invocationManager.postInvoke(inv);
                    }
                } else {
                    Transaction tx = sessionCtx.getTransaction();
                    try {
                        if (tx != null && tx.getStatus() != 6) {
                            tx.setRollbackOnly();
                        }
                    }
                    catch (Exception ex) {
                        _logger.log(Level.FINE, "forceDestroyBean exception", ex);
                    }
                }
            }
            StatelessSessionContainer.this.transactionManager.ejbDestroyed(sessionCtx);
            sessionCtx.setTransaction(null);
            sessionCtx.deleteAllReferences();
        }
    }
}

