/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.stats;

import com.sun.ejb.base.stats.EJBCacheStatsImpl;
import com.sun.ejb.base.stats.EJBMethodStatsManagerImpl;
import com.sun.ejb.base.stats.EJBPoolStatsImpl;
import com.sun.ejb.base.stats.EJBStatsImpl;
import com.sun.ejb.base.stats.EJBTimedObjectStatsImpl;
import com.sun.ejb.base.stats.EntityBeanStatsImpl;
import com.sun.ejb.base.stats.HAStatefulSessionStoreMonitor;
import com.sun.ejb.base.stats.HAStatefulSessionStoreStatsImpl;
import com.sun.ejb.base.stats.MessageDrivenBeanStatsImpl;
import com.sun.ejb.base.stats.StatefulSessionBeanStatsImpl;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.base.stats.StatefulSessionStoreStatsImpl;
import com.sun.ejb.base.stats.StatelessSessionBeanStatsImpl;
import com.sun.ejb.spi.stats.EJBCacheStatsProvider;
import com.sun.ejb.spi.stats.EJBMethodStatsManager;
import com.sun.ejb.spi.stats.EJBPoolStatsProvider;
import com.sun.ejb.spi.stats.EJBStatsProvider;
import com.sun.ejb.spi.stats.EJBTimedObjectStatsProvider;
import com.sun.ejb.spi.stats.EntityBeanStatsProvider;
import com.sun.ejb.spi.stats.MessageDrivenBeanStatsProvider;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.ejb.spi.stats.StatefulSessionBeanStatsProvider;
import com.sun.ejb.spi.stats.StatelessSessionBeanStatsProvider;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.EJBCacheStats;
import com.sun.enterprise.admin.monitor.stats.EJBPoolStats;
import com.sun.enterprise.admin.monitor.stats.TimerServiceStats;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.EntityBeanStats;
import javax.management.j2ee.statistics.MessageDrivenBeanStats;
import javax.management.j2ee.statistics.StatefulSessionBeanStats;
import javax.management.j2ee.statistics.StatelessSessionBeanStats;
import javax.management.j2ee.statistics.Stats;

public class MonitoringRegistryMediator
implements MonitoringLevelListener {
    private static final int ENTITY_CONTAINER_TYPE = 0;
    private static final int STATELESS_CONTAINER_TYPE = 1;
    private static final int STATEFUL_CONTAINER_TYPE = 2;
    private static final int MESSAGE_CONTAINER_TYPE = 3;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private String appName;
    private String modName;
    private String ejbName;
    private int containerType;
    private MonitoringLevel currentMonitoringLevel;
    private MonitoringRegistry registry;
    private EJBStatsProvider ejbStatsProvider;
    private EJBCacheStatsProvider ejbCacheStatsProvider;
    private EJBPoolStatsProvider ejbPoolStatsProvider;
    private MonitorableSFSBStoreManager sfsbStoreStatsProvider;
    private EJBTimedObjectStatsProvider ejbTimedObjectStatsProvider;
    private EJBStatsImpl ejbStatsImpl;
    private EJBCacheStatsImpl ejbCacheStatsImpl;
    private EJBPoolStatsImpl ejbPoolStatsImpl;
    private EJBTimedObjectStatsImpl ejbTimedObjectStatsImpl;
    private EJBMethodStatsManagerImpl ejbMethodStatsManager;
    private StatefulSessionStoreMonitor sfsbStoreMonitor;
    private boolean isHAStore;
    private Level TRACE_LEVEL = Level.INFO;
    private Object[] logParams = null;

    public MonitoringRegistryMediator(String ejbName, String modName, String appName) {
        this.appName = appName;
        this.modName = modName;
        this.ejbName = ejbName;
        this.logParams = new Object[]{ejbName, modName, appName};
        this.registry = ApplicationServer.getServerContext().getMonitoringRegistry();
        this.ejbMethodStatsManager = new EJBMethodStatsManagerImpl(this.registry, ejbName, modName, appName);
    }

    public void registerProvider(StatelessSessionBeanStatsProvider provider) {
        this.ejbStatsProvider = provider;
        this.containerType = 1;
        this.registry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.EJB);
        this.currentMonitoringLevel = this.getCurrentMonitoringLevel();
        if (!this.isMonitoringOff()) {
            this.registerContainerStats();
        }
    }

    public void registerProvider(StatefulSessionBeanStatsProvider provider) {
        this.ejbStatsProvider = provider;
        this.containerType = 2;
        this.registry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.EJB);
        this.currentMonitoringLevel = this.getCurrentMonitoringLevel();
        if (!this.isMonitoringOff()) {
            this.registerContainerStats();
        }
    }

    public void registerProvider(EntityBeanStatsProvider provider) {
        this.ejbStatsProvider = provider;
        this.containerType = 0;
        this.registry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.EJB);
        this.currentMonitoringLevel = this.getCurrentMonitoringLevel();
        if (!this.isMonitoringOff()) {
            this.registerContainerStats();
        }
    }

    public void registerProvider(MessageDrivenBeanStatsProvider provider) {
        this.ejbStatsProvider = provider;
        this.containerType = 3;
        this.registry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.EJB);
        this.currentMonitoringLevel = this.getCurrentMonitoringLevel();
        if (!this.isMonitoringOff()) {
            this.registerContainerStats();
        }
    }

    public void registerProvider(EJBCacheStatsProvider provider) {
        this.ejbCacheStatsProvider = provider;
        if (!this.isMonitoringOff()) {
            this.registerCacheStats();
        }
    }

    public void registerProvider(EJBPoolStatsProvider provider) {
        this.ejbPoolStatsProvider = provider;
        if (!this.isMonitoringOff()) {
            this.registerPoolStats();
        }
    }

    public StatefulSessionStoreMonitor registerProvider(MonitorableSFSBStoreManager provider, boolean isHAStore) {
        this.sfsbStoreStatsProvider = provider;
        this.isHAStore = isHAStore;
        this.sfsbStoreMonitor = isHAStore ? new HAStatefulSessionStoreMonitor() : new StatefulSessionStoreMonitor();
        if (!this.isMonitoringOff()) {
            this.registerSFSBStoreStats();
        }
        return this.sfsbStoreMonitor;
    }

    public EJBMethodStatsManager getEJBMethodStatsManager() {
        return this.ejbMethodStatsManager;
    }

    public void registerEJBMethods(Method[] methods) {
        this.ejbMethodStatsManager.registerMethods(methods);
        if (this.isMonitoringHigh()) {
            this.ejbMethodStatsManager.setMethodMonitorOn(true);
        }
    }

    public void registerProvider(EJBTimedObjectStatsProvider provider) {
        this.ejbTimedObjectStatsProvider = provider;
        if (!this.isMonitoringOff()) {
            this.registerTimedObjectStats();
        }
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLevel(MonitoringLevel fromLevel, MonitoringLevel toLevel, MonitoredObjectType type) {
        if (type == MonitoredObjectType.EJB) {
            MonitoringRegistryMediator monitoringRegistryMediator = this;
            synchronized (monitoringRegistryMediator) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] Level changed from: " + MonitoringRegistryMediator.monitoringLevelAsString(this.currentMonitoringLevel) + " to: " + MonitoringRegistryMediator.monitoringLevelAsString(toLevel));
                }
            }
            this.currentMonitoringLevel = toLevel;
            if (toLevel == MonitoringLevel.OFF) {
                this.deregisterPoolStats();
                this.deregisterCacheStats();
                this.ejbMethodStatsManager.setMethodMonitorOn(false);
                this.deregisterSFSBStoreStats();
                this.deregisterContainerStats();
                this.deregisterTimedObjectStats();
            } else {
                this.registerContainerStats();
                this.registerPoolStats();
                this.registerCacheStats();
                this.registerSFSBStoreStats();
                this.ejbMethodStatsManager.setMethodMonitorOn(toLevel == MonitoringLevel.HIGH);
                this.registerTimedObjectStats();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        try {
            this.deregisterPoolStats();
            this.deregisterCacheStats();
            this.ejbMethodStatsManager.undeploy();
            this.deregisterContainerStats();
            this.deregisterSFSBStoreStats();
            this.deregisterTimedObjectStats();
        }
        finally {
            this.ejbStatsProvider = null;
            this.ejbCacheStatsProvider = null;
            this.ejbPoolStatsProvider = null;
            this.ejbMethodStatsManager = null;
            this.sfsbStoreStatsProvider = null;
            this.sfsbStoreMonitor = null;
            this.ejbTimedObjectStatsProvider = null;
            this.registry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
        }
    }

    private void registerContainerStats() {
        if (this.ejbStatsProvider == null || this.ejbStatsImpl != null) {
            return;
        }
        try {
            switch (this.containerType) {
                case 1: {
                    StatelessSessionBeanStatsImpl slsbImpl = new StatelessSessionBeanStatsImpl((StatelessSessionBeanStatsProvider)this.ejbStatsProvider);
                    this.registry.registerStatelessSessionBeanStats((StatelessSessionBeanStats)slsbImpl, this.ejbName, this.modName, this.appName, null);
                    this.ejbStatsImpl = slsbImpl;
                    break;
                }
                case 2: {
                    StatefulSessionBeanStatsImpl sfsbImpl = new StatefulSessionBeanStatsImpl((StatefulSessionBeanStatsProvider)this.ejbStatsProvider);
                    this.registry.registerStatefulSessionBeanStats((StatefulSessionBeanStats)sfsbImpl, this.ejbName, this.modName, this.appName, null);
                    this.ejbStatsImpl = sfsbImpl;
                    break;
                }
                case 0: {
                    EntityBeanStatsImpl entityImpl = new EntityBeanStatsImpl((EntityBeanStatsProvider)this.ejbStatsProvider);
                    this.registry.registerEntityBeanStats((EntityBeanStats)entityImpl, this.ejbName, this.modName, this.appName, null);
                    this.ejbStatsImpl = entityImpl;
                    break;
                }
                case 3: {
                    MessageDrivenBeanStatsImpl mdbImpl = new MessageDrivenBeanStatsImpl((MessageDrivenBeanStatsProvider)this.ejbStatsProvider);
                    this.registry.registerMessageDrivenBeanStats((MessageDrivenBeanStats)mdbImpl, this.ejbName, this.modName, this.appName, null);
                    this.ejbStatsImpl = mdbImpl;
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[MonitoringMediator] registered  container stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
            }
        }
        catch (MonitoringRegistrationException monRegEx) {
            this.ejbStatsImpl = null;
            _logger.log(Level.WARNING, "base.stats.mediator.ejb.register.monreg.error", this.logParams);
            _logger.log(Level.FINE, "", monRegEx);
        }
        catch (Exception ex) {
            this.ejbStatsImpl = null;
            _logger.log(Level.WARNING, "base.stats.mediator.ejb.register.error", this.logParams);
            _logger.log(Level.FINE, "", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterContainerStats() {
        try {
            if (this.ejbStatsImpl != null) {
                switch (this.containerType) {
                    case 1: {
                        this.registry.unregisterStatelessSessionBeanStats(this.ejbName, this.modName, this.appName);
                        break;
                    }
                    case 2: {
                        this.registry.unregisterStatefulSessionBeanStats(this.ejbName, this.modName, this.appName);
                        break;
                    }
                    case 0: {
                        this.registry.unregisterEntityBeanStats(this.ejbName, this.modName, this.appName);
                        break;
                    }
                    case 3: {
                        this.registry.unregisterMessageDrivenBeanStats(this.ejbName, this.modName, this.appName);
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] unregistered  container stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
        }
        catch (MonitoringRegistrationException monRegEx) {
            _logger.log(Level.WARNING, "base.stats.mediator.ejb.unregister.monreg.error", this.logParams);
            _logger.log(Level.FINE, "", monRegEx);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "base.stats.mediator.ejb.unregister.error", this.logParams);
            _logger.log(Level.FINE, "", ex);
        }
        finally {
            this.ejbStatsImpl = null;
        }
    }

    private void registerPoolStats() {
        if (this.ejbPoolStatsProvider != null && this.ejbPoolStatsImpl == null) {
            try {
                this.ejbPoolStatsImpl = new EJBPoolStatsImpl(this.ejbPoolStatsProvider);
                this.registry.registerEJBPoolStats((EJBPoolStats)this.ejbPoolStatsImpl, this.ejbName, this.modName, this.appName, null);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] registered  pool stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
            catch (MonitoringRegistrationException monRegEx) {
                this.ejbPoolStatsImpl = null;
                _logger.log(Level.WARNING, "base.stats.mediator.pool.register.monreg.error", this.logParams);
                _logger.log(Level.FINE, "", monRegEx);
            }
            catch (Exception ex) {
                this.ejbPoolStatsImpl = null;
                _logger.log(Level.WARNING, "base.stats.mediator.pool.register.error", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
        }
    }

    private void registerCacheStats() {
        if (this.ejbCacheStatsProvider != null && this.ejbCacheStatsImpl == null) {
            try {
                this.ejbCacheStatsImpl = new EJBCacheStatsImpl(this.ejbCacheStatsProvider);
                this.registry.registerEJBCacheStats((EJBCacheStats)this.ejbCacheStatsImpl, this.ejbName, this.modName, this.appName, null);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] registered  cache stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
            catch (MonitoringRegistrationException monRegEx) {
                this.ejbCacheStatsImpl = null;
                _logger.log(Level.WARNING, "base.stats.mediator.cache.register.monreg.error", this.logParams);
                _logger.log(Level.FINE, "", monRegEx);
            }
            catch (Exception ex) {
                this.ejbCacheStatsImpl = null;
                _logger.log(Level.WARNING, "base.stats.mediator.cache.register.error", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
        }
    }

    private void registerSFSBStoreStats() {
        if (this.sfsbStoreMonitor != null) {
            StatefulSessionStoreStatsImpl statsImpl = null;
            statsImpl = this.isHAStore ? new HAStatefulSessionStoreStatsImpl(this.sfsbStoreStatsProvider) : new StatefulSessionStoreStatsImpl(this.sfsbStoreStatsProvider);
            this.sfsbStoreMonitor.setDelegate(statsImpl);
            this.sfsbStoreStatsProvider.monitoringLevelChanged(true);
        }
    }

    private void registerTimedObjectStats() {
        if (this.ejbTimedObjectStatsProvider != null) {
            this.ejbTimedObjectStatsProvider.monitoringLevelChanged(true);
            if (this.ejbTimedObjectStatsImpl == null) {
                try {
                    this.ejbTimedObjectStatsImpl = new EJBTimedObjectStatsImpl(this.ejbTimedObjectStatsProvider);
                    this.registry.registerTimerStats((TimerServiceStats)this.ejbTimedObjectStatsImpl, this.ejbName, this.modName, this.appName, null);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[MonitoringMediator] registered  timed Object stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                    }
                }
                catch (MonitoringRegistrationException monRegEx) {
                    this.ejbTimedObjectStatsImpl = null;
                    _logger.log(Level.WARNING, "base.stats.mediator.timedObject.register.monreg.error", this.logParams);
                    _logger.log(Level.FINE, "", monRegEx);
                }
                catch (Exception ex) {
                    this.ejbTimedObjectStatsImpl = null;
                    _logger.log(Level.WARNING, "base.stats.mediator.timedObject.register.error", this.logParams);
                    _logger.log(Level.FINE, "", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterPoolStats() {
        if (this.ejbPoolStatsProvider != null && this.ejbPoolStatsImpl != null) {
            try {
                this.registry.unregisterEJBPoolStats(this.ejbName, this.modName, this.appName);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] unregistered  pool stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
            catch (MonitoringRegistrationException monRegEx) {
                _logger.log(Level.WARNING, "base.stats.mediator.pool.unregister.monreg.error", this.logParams);
                _logger.log(Level.FINE, "", monRegEx);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "base.stats.mediator.pool.unregister.error", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
            finally {
                this.ejbPoolStatsImpl = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterCacheStats() {
        if (this.ejbCacheStatsProvider != null && this.ejbCacheStatsImpl != null) {
            try {
                this.registry.unregisterEJBCacheStats(this.ejbName, this.modName, this.appName);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] unregistered  cache stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
            catch (MonitoringRegistrationException monRegEx) {
                _logger.log(Level.WARNING, "base.stats.mediator.cache.unregister.monreg.error", this.logParams);
                _logger.log(Level.FINE, "", monRegEx);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "base.stats.mediator.cache.unregister.error", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
            finally {
                this.ejbCacheStatsImpl = null;
            }
        }
    }

    private void deregisterSFSBStoreStats() {
        if (this.sfsbStoreMonitor != null) {
            this.sfsbStoreStatsProvider.monitoringLevelChanged(false);
            this.sfsbStoreMonitor.setDelegate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterTimedObjectStats() {
        if (this.ejbTimedObjectStatsProvider != null && this.ejbTimedObjectStatsImpl != null) {
            try {
                this.ejbTimedObjectStatsProvider.monitoringLevelChanged(false);
                this.registry.unregisterTimerStats(this.ejbName, this.modName, this.appName);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[MonitoringMediator] unregistered  timed Object stats for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                }
            }
            catch (MonitoringRegistrationException monRegEx) {
                _logger.log(Level.WARNING, "base.stats.mediator.timedObject.unregister.monreg.error", this.logParams);
                _logger.log(Level.FINE, "", monRegEx);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "base.stats.mediator.timedObject.unregister.error", this.logParams);
                _logger.log(Level.FINE, "", ex);
            }
            finally {
                this.ejbTimedObjectStatsImpl = null;
            }
        }
    }

    public void logMonitoredComponentsData(boolean logMethodData) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[BEGIN Container-Stats: ").append(this.ejbName).append("]");
        this.ejbStatsProvider.appendStats(sbuf);
        if (this.ejbCacheStatsProvider != null) {
            this.ejbCacheStatsProvider.appendStats(sbuf);
        }
        if (this.ejbPoolStatsProvider != null) {
            this.ejbPoolStatsProvider.appendStats(sbuf);
        }
        if (logMethodData) {
            this.ejbMethodStatsManager.appendStats(sbuf);
        }
        if (this.ejbTimedObjectStatsProvider != null) {
            this.ejbTimedObjectStatsProvider.appendStats(sbuf);
        }
        if (this.sfsbStoreMonitor != null) {
            sbuf.append(this.isHAStore ? "[HASFSBStore " : "[SFSBStore ");
            this.sfsbStoreMonitor.appendStats(sbuf);
            this.sfsbStoreStatsProvider.appendStats(sbuf);
            sbuf.append("]");
        }
        sbuf.append("[END   Container-Stats: ").append(this.ejbName).append("]");
        _logger.log(Level.INFO, sbuf.toString());
    }

    private final synchronized MonitoringLevel getCurrentMonitoringLevel() {
        MonitoringLevel level = MonitoringLevel.OFF;
        try {
            Config cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String levelStr = cfg.getMonitoringService().getModuleMonitoringLevels().getEjbContainer();
            level = MonitoringLevel.instance((String)levelStr);
        }
        catch (ConfigException configEx) {
            _logger.log(Level.WARNING, "ejb_base_stats_mediator_configex", configEx);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[MonitoringMediator] currentLevel: " + MonitoringRegistryMediator.monitoringLevelAsString(level));
        }
        return level;
    }

    private final synchronized boolean isMonitoringOff() {
        return this.currentMonitoringLevel == MonitoringLevel.OFF;
    }

    private final synchronized boolean isMonitoringLow() {
        return this.currentMonitoringLevel == MonitoringLevel.LOW;
    }

    private final synchronized boolean isMonitoringHigh() {
        return this.currentMonitoringLevel == MonitoringLevel.HIGH;
    }

    private static final String monitoringLevelAsString(MonitoringLevel level) {
        if (level == MonitoringLevel.OFF) {
            return "OFF";
        }
        if (level == MonitoringLevel.HIGH) {
            return "HIGH";
        }
        return "LOW";
    }
}

