/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.initialization;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.initialization.AbstractPersistenceStrategyBuilder;
import com.sun.ejb.base.sfsb.store.FileStoreManager;
import com.sun.ejb.spi.sfsb.initialization.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;

public class FileStrategyBuilder
extends AbstractPersistenceStrategyBuilder {
    public void initializePersistenceStrategy(SFSBContainerInitialization container, EjbDescriptor descriptor) {
        try {
            super.initializePersistenceStrategy(container, descriptor);
            SFSBStoreManager storeManager = this.createStoreManager(container, descriptor);
            container.setSFSBStoreManager(storeManager);
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Could not initialize container using FilestrategyBuilder", th);
        }
    }

    private SFSBStoreManager createStoreManager(SFSBContainerInitialization container, EjbDescriptor descriptor) {
        FileStoreManager manager = new FileStoreManager();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.ejb.spi.sfsb.store.name", descriptor.getName());
        map.put("com.sun.ejb.spi.sfsb.store.containerid", new Long(descriptor.getUniqueId()));
        CacheProperties cacheProps = new CacheProperties(descriptor);
        map.put("com.sun.ejb.spi.sfsb.store.timeout", new Integer(cacheProps.getRemovalTimeoutInSeconds()));
        map.put("com.sun.ejb.spi.sfsb.store.grace.timeout", new Integer(super.getRemovalGracePeriodInSeconds()));
        map.put("com.sun.ejb.spi.sfsb.store.directory", this.getPassivationDirectoryName(descriptor));
        _logger.log(Level.FINE, "Initialzing FileStoreManager with: " + map);
        manager.initSessionStore(map);
        _logger.log(Level.FINE, "INITIALZED FileStoreManager: " + manager);
        return manager;
    }

    private String getPassivationDirectoryName(EjbDescriptor desc) {
        String passivationDirName = null;
        try {
            ServerContext ctx = ApplicationServer.getServerContext();
            InstanceEnvironment env = ctx.getInstanceEnvironment();
            Application application = desc.getApplication();
            Object dirName = null;
            String componentSeparator = "_";
            if (application.isVirtual()) {
                String archURI = desc.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                passivationDirName = env.getModulePassivatedEjbPath() + File.separator + FileUtils.makeFriendlyFilename(archURI) + componentSeparator + desc.getName();
            } else {
                passivationDirName = env.getApplicationPassivatedEjbPath() + File.separator + application.getRegistrationName() + componentSeparator + desc.getName() + componentSeparator + desc.getUniqueId();
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "ejb.sfsb_helper_get_passivation_dir_failed", th);
        }
        return passivationDirName;
    }
}

