/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.codegen;

import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.impl.codegen.ClassInfo;
import com.sun.corba.ee.impl.codegen.ClassInfoReflectiveImpl;
import com.sun.corba.ee.impl.codegen.CurrentClassLoader;
import com.sun.corba.ee.impl.codegen.NodeBase;
import com.sun.corba.ee.impl.codegen.Visitor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
extends NodeBase {
    private String name;
    private String signature;
    private int size;
    private Sort sort;
    private boolean isNumber;
    private int wideningNumber;
    private Type memberType;
    private ClassInfo classInfo;
    private Class<?> typeClass;
    private static final Type myVoid = new Type("void", "V", 0, false, Sort.PRIMITIVE, -1);
    private static final Type myNull = new Type("NULL", "N", 1, false, Sort.PRIMITIVE, -1);
    private static final Type myBoolean = new Type("boolean", "Z", 1, false, Sort.PRIMITIVE, -1);
    private static final Type myByte = new Type("byte", "B", 1, true, Sort.PRIMITIVE, 1);
    private static final Type myChar = new Type("char", "C", 1, false, Sort.PRIMITIVE, 2);
    private static final Type myShort = new Type("short", "S", 1, true, Sort.PRIMITIVE, 2);
    private static final Type myInt = new Type("int", "I", 1, true, Sort.PRIMITIVE, 3);
    private static final Type myLong = new Type("long", "J", 2, true, Sort.PRIMITIVE, 4);
    private static final Type myFloat = new Type("float", "F", 1, true, Sort.PRIMITIVE, 5);
    private static final Type myDouble = new Type("double", "D", 2, true, Sort.PRIMITIVE, 6);
    private static final Map<Class, Type> ptcToType = new HashMap<Class, Type>();
    private static final Type myObject;
    private static final Type myString;
    private static final Type myClass;
    private static final Type myCloneable;

    private Type(String name, String signature, int size, boolean isNumber, Sort sort, int wideningNumber, Type memberType) {
        super(null);
        this.name = name;
        this.signature = signature;
        this.size = size;
        this.isNumber = isNumber;
        this.sort = sort;
        this.wideningNumber = wideningNumber;
        this.classInfo = null;
    }

    private Type(String name, String signature, int size, boolean isNumber, Sort sort, int wideningNumber) {
        this(name, signature, size, isNumber, sort, wideningNumber, null);
    }

    private static String getClassSignature(String className) {
        return "L" + className + ";";
    }

    public static Type _array(Type memberType) {
        return new Type(memberType.name() + "[]", "[" + memberType.signature, 1, false, Sort.ARRAY, -1, memberType);
    }

    public static Type _class(String name) {
        return new Type(name, Type.getClassSignature(name), 1, false, Sort.CLASS, -1);
    }

    public static Type _classGenerator(ClassGenerator cg) {
        Type result = Type._class(cg.name());
        result.classInfo = cg;
        return result;
    }

    public static Type type(Class cls) {
        if (cls.isArray()) {
            return Type._array(Type.type(cls.getComponentType()));
        }
        if (!cls.isPrimitive()) {
            Type result = Type._class(cls.getName());
            result.typeClass = cls;
            return result;
        }
        Type type = ptcToType.get(cls);
        assert (type != null);
        return type;
    }

    public static Type _void() {
        return myVoid;
    }

    public static Type _null() {
        return myNull;
    }

    public static Type _boolean() {
        return myBoolean;
    }

    public static Type _byte() {
        return myByte;
    }

    public static Type _char() {
        return myChar;
    }

    public static Type _short() {
        return myShort;
    }

    public static Type _int() {
        return myInt;
    }

    public static Type _long() {
        return myLong;
    }

    public static Type _float() {
        return myFloat;
    }

    public static Type _double() {
        return myDouble;
    }

    public static Type _Object() {
        return myObject;
    }

    public static Type _String() {
        return myString;
    }

    public static Type _Class() {
        return myClass;
    }

    public boolean isPrimitive() {
        return this.sort == Sort.PRIMITIVE;
    }

    public boolean isArray() {
        return this.sort == Sort.ARRAY;
    }

    public Type memberType() {
        if (this.isArray()) {
            return this.memberType();
        }
        throw new IllegalStateException("memberType() only valid for Array types");
    }

    public int size() {
        return this.size;
    }

    public String signature() {
        return this.signature;
    }

    public String name() {
        return this.name;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public ClassInfo classInfo() throws ClassNotFoundException {
        if (this.classInfo == null) {
            if (this.isArray()) {
                throw new IllegalStateException("Cannot get ClassInfo for array type " + this.name);
            }
            if (this.isPrimitive()) {
                throw new IllegalStateException("Cannot get ClassInfo for primitive type " + this.name);
            }
            if (this.typeClass == null) {
                try {
                    this.typeClass = Class.forName(this.name, true, CurrentClassLoader.get());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Cannot load class for type " + this.name);
                }
            }
            this.classInfo = new ClassInfoReflectiveImpl(this);
        }
        return this.classInfo;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Type[" + this.name + "," + this.signature + "," + this.size + "," + (Object)((Object)this.sort) + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Type other = (Type)Type.class.cast(obj);
        return this.signature.equals(other.signature);
    }

    public boolean isMethodInvocationConvertibleFrom(Type t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.equals(t)) {
            return true;
        }
        if (this.isPrimitive()) {
            if (!t.isPrimitive()) {
                return false;
            }
            if (this.wideningNumber < 0 || t.wideningNumber < 0) {
                return false;
            }
            return t.wideningNumber < this.wideningNumber;
        }
        if (this.equals(Type._Object())) {
            return true;
        }
        if (this.equals(Type._null())) {
            return true;
        }
        if (this.isArray()) {
            if (t.equals(myCloneable)) {
                return true;
            }
            if (!this.memberType().isPrimitive()) {
                return this.memberType().isMethodInvocationConvertibleFrom(t.memberType());
            }
            return false;
        }
        try {
            return t.classInfo().isSubclass(this.classInfo());
        }
        catch (ClassNotFoundException exc) {
            return false;
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitType(this);
    }

    static {
        ptcToType.put(Boolean.TYPE, myBoolean);
        ptcToType.put(Byte.TYPE, myByte);
        ptcToType.put(Character.TYPE, myChar);
        ptcToType.put(Short.TYPE, myShort);
        ptcToType.put(Integer.TYPE, myInt);
        ptcToType.put(Long.TYPE, myLong);
        ptcToType.put(Float.TYPE, myFloat);
        ptcToType.put(Double.TYPE, myDouble);
        ptcToType.put(Void.TYPE, myVoid);
        myObject = Type._class("java.lang.Object");
        myString = Type._class("java.lang.String");
        myClass = Type._class("java.lang.Class");
        myCloneable = Type._class("java.lang.Cloneable");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Sort {
        PRIMITIVE,
        ARRAY,
        CLASS;

    }
}

