/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.SlotTable;
import com.sun.corba.ee.impl.interceptors.SlotTableStack;
import com.sun.corba.ee.impl.logging.OMGSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public class PICurrent
extends LocalObject
implements Current {
    private int slotCounter;
    private ORB myORB;
    private OMGSystemException wrapper;
    private boolean orbInitializing;
    private ThreadLocal threadLocalSlotTable = new ThreadLocal(){

        protected Object initialValue() {
            SlotTable table = new SlotTable(PICurrent.this.myORB, PICurrent.this.slotCounter);
            return new SlotTableStack(PICurrent.this.myORB, table);
        }
    };

    PICurrent(ORB myORB) {
        this.myORB = myORB;
        this.wrapper = OMGSystemException.get(myORB, "rpc.protocol");
        this.orbInitializing = true;
        this.slotCounter = 0;
    }

    int allocateSlotId() {
        int slotId = this.slotCounter++;
        return slotId;
    }

    SlotTable getSlotTable() {
        SlotTable table = ((SlotTableStack)this.threadLocalSlotTable.get()).peekSlotTable();
        return table;
    }

    void pushSlotTable() {
        SlotTableStack st = (SlotTableStack)this.threadLocalSlotTable.get();
        st.pushSlotTable();
    }

    void popSlotTable() {
        SlotTableStack st = (SlotTableStack)this.threadLocalSlotTable.get();
        st.popSlotTable();
    }

    public void set_slot(int id, Any data) throws InvalidSlot {
        if (this.orbInitializing) {
            throw this.wrapper.invalidPiCall3();
        }
        this.getSlotTable().set_slot(id, data);
    }

    public Any get_slot(int id) throws InvalidSlot {
        if (this.orbInitializing) {
            throw this.wrapper.invalidPiCall4();
        }
        return this.getSlotTable().get_slot(id);
    }

    void resetSlotTable() {
        this.getSlotTable().resetSlots();
    }

    void setORBInitializing(boolean init) {
        this.orbInitializing = init;
    }
}

