/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import java.io.PrintStream;

public class Printer {
    private static final int DEFAULT_INCREMENT = 4;
    private PrintStream ps;
    private int increment;
    private char padChar;
    private int lineNumber;
    private int indent;
    private char[] pad;
    private StringBuilder bld;

    public Printer(PrintStream ps) {
        this(ps, 4, ' ');
    }

    public Printer(PrintStream ps, int increment, char padChar) {
        this.ps = ps;
        this.increment = increment;
        this.padChar = padChar;
        this.lineNumber = 1;
        this.indent = 0;
        this.bld = new StringBuilder();
        this.fill();
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public Printer p(String str) {
        this.bld.append(str);
        return this;
    }

    public Printer in() {
        this.indent += this.increment;
        this.fill();
        return this;
    }

    public Printer out() {
        if (this.indent < this.increment) {
            throw new IllegalStateException("Cannot undent past start of line");
        }
        this.indent -= this.increment;
        this.fill();
        return this;
    }

    private void fill() {
        this.pad = new char[this.indent];
        for (int ctr = 0; ctr < this.pad.length; ++ctr) {
            this.pad[ctr] = this.padChar;
        }
    }

    public Printer nl() {
        ++this.lineNumber;
        this.ps.println(this.bld.toString());
        this.bld = new StringBuilder();
        this.bld.append(this.pad);
        return this;
    }
}

