/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.ASMUtil;
import com.sun.corba.ee.impl.codegen.AssignmentStatement;
import com.sun.corba.ee.impl.codegen.DefinitionStatement;
import com.sun.corba.ee.impl.codegen.ExpressionFactory;
import com.sun.corba.ee.impl.codegen.IfStatement;
import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.impl.codegen.ReturnStatement;
import com.sun.corba.ee.impl.codegen.Statement;
import com.sun.corba.ee.impl.codegen.StatementBase;
import com.sun.corba.ee.impl.codegen.SwitchStatement;
import com.sun.corba.ee.impl.codegen.ThrowStatement;
import com.sun.corba.ee.impl.codegen.TryStatement;
import com.sun.corba.ee.impl.codegen.Util;
import com.sun.corba.ee.impl.codegen.Variable;
import com.sun.corba.ee.impl.codegen.VariableDelegateImpl;
import com.sun.corba.ee.impl.codegen.VariableImpl;
import com.sun.corba.ee.impl.codegen.Visitor;
import com.sun.corba.ee.impl.codegen.WhileStatement;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStatement
extends StatementBase {
    private List<Statement> body = new ArrayList<Statement>();
    private Map<String, DefinitionStatement> definitions = new HashMap<String, DefinitionStatement>();

    static Expression splitVariables(Node parent, Expression expr) {
        if (expr instanceof VariableImpl) {
            Variable evar = (Variable)Variable.class.cast(expr);
            VariableDelegateImpl var = new VariableDelegateImpl(parent, evar);
            ASMUtil.requiredEmitterType.set(var, ASMUtil.RequiredEmitterType.GETTER);
            return var;
        }
        return expr;
    }

    static List<Expression> splitVariables(Node parent, List<Expression> exprs) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        if (exprs != null) {
            for (Expression expr : exprs) {
                result.add(BlockStatement.splitVariables(parent, expr));
            }
        }
        return result;
    }

    BlockStatement(Node parent) {
        super(parent);
    }

    public Variable getVar(String ident) {
        Variable result = null;
        DefinitionStatement ds = this.definitions.get(ident);
        if (ds != null) {
            result = ds.var();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    public List<Statement> body() {
        return this.body;
    }

    public ExpressionFactory exprFactory() {
        return new ExpressionFactory(this);
    }

    public void addReturn() {
        this.body.add(new ReturnStatement(this));
    }

    public void addReturn(Expression expr) {
        this.body.add(new ReturnStatement(this, BlockStatement.splitVariables((Node)this, expr)));
    }

    public IfStatement addIf(Expression cond) {
        IfStatement result = new IfStatement(this, BlockStatement.splitVariables((Node)this, cond));
        this.body.add(result);
        return result;
    }

    public TryStatement addTry() {
        TryStatement result = new TryStatement(this);
        this.body.add(result);
        return result;
    }

    public void addThrow(Expression expr) {
        Util.checkScope(expr);
        this.body.add(new ThrowStatement(this, BlockStatement.splitVariables((Node)this, expr)));
    }

    private void checkSwitchExpressionType(Type type) {
        if (type.size() != 1 || type.equals(Type._boolean())) {
            throw new IllegalArgumentException("A switch expression must have type char, byte, short, or int");
        }
    }

    public SwitchStatement addSwitch(Expression value) {
        Util.checkScope(value);
        this.checkSwitchExpressionType(value.type());
        SwitchStatement result = new SwitchStatement(this, BlockStatement.splitVariables((Node)this, value));
        this.body.add(result);
        return result;
    }

    public WhileStatement addWhile(Expression expr) {
        Util.checkScope(expr);
        WhileStatement result = new WhileStatement(this, BlockStatement.splitVariables((Node)this, expr));
        this.body.add(result);
        return result;
    }

    public void addExpression(Expression expr) {
        Util.checkScope(expr);
        this.body.add(BlockStatement.splitVariables((Node)this, expr));
    }

    public void addAssign(Expression left, Expression right) {
        Util.checkScope(left);
        Util.checkScope(right);
        this.body.add(new AssignmentStatement(this, BlockStatement.splitVariables((Node)this, left), BlockStatement.splitVariables((Node)this, right)));
    }

    public void addDefinition(Type type, String ident, Expression value) {
        Util.checkScope(value);
        if (this.definitions.containsKey(ident)) {
            throw new IllegalArgumentException("This scope already contains a variable named " + ident);
        }
        VariableImpl var = new VariableImpl(this, type, ident);
        DefinitionStatement ds = new DefinitionStatement(this, var, BlockStatement.splitVariables((Node)this, value));
        this.body.add(ds);
        this.definitions.put(ident, ds);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBlockStatement(this);
    }
}

