/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheKeyGenerator;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.appserv.web.cache.mapping.Constants;
import com.sun.appserv.web.cache.mapping.ConstraintField;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.enterprise.web.logging.pwc.LogDomains;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DefaultCacheHelper
implements CacheHelper {
    public static final String ATTR_CACHING_FILTER_NAME = "com.sun.ias.web.cachingFilterName";
    public static final String PROP_KEY_GENERATOR_ATTR_NAME = "cacheKeyGeneratorAttrName";
    private static Logger _logger;
    private static boolean _isTraceEnabled;
    private static ResourceBundle _rb;
    ServletContext context;
    CacheManager manager;
    String attrKeyGenerator = null;
    boolean isKeyGeneratorChecked = false;
    CacheKeyGenerator keyGenerator;

    public void setCacheManager(CacheManager manager) {
        this.manager = manager;
    }

    public void init(ServletContext context, Map props) {
        this.context = context;
        this.attrKeyGenerator = (String)props.get(PROP_KEY_GENERATOR_ATTR_NAME);
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web.pwc");
        _isTraceEnabled = _logger.isLoggable(Level.FINE);
        _rb = _logger.getResourceBundle();
    }

    private CacheMapping lookupCacheMapping(HttpServletRequest request) {
        String name = (String)request.getAttribute(ATTR_CACHING_FILTER_NAME);
        return this.manager.getCacheMapping(name);
    }

    public String getCacheKey(HttpServletRequest request) {
        String key;
        CacheMapping mapping = this.lookupCacheMapping(request);
        if (!this.isKeyGeneratorChecked && this.attrKeyGenerator != null) {
            try {
                this.keyGenerator = (CacheKeyGenerator)this.context.getAttribute(this.attrKeyGenerator);
            }
            catch (ClassCastException cce) {
                _logger.log(Level.WARNING, "cache.defaultHelp.illegalKeyGenerator", cce);
            }
            this.isKeyGeneratorChecked = true;
        }
        if (this.keyGenerator != null && (key = this.keyGenerator.getCacheKey(this.context, request)) != null) {
            return key;
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append(request.getServletPath());
        Field[] keys = mapping.getKeyFields();
        for (int i = 0; i < keys.length; ++i) {
            Object value = keys[i].getValue(this.context, request);
            if (value == null) {
                if (_isTraceEnabled) {
                    _logger.fine("DefaultCacheHelper: cannot find all the required key fields in the request " + request.getServletPath());
                }
                return null;
            }
            sb.append(";");
            sb.append(Constants.KEY_PREFIXES[keys[i].getScope()]);
            sb.append(keys[i].getName());
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    public boolean isCacheable(HttpServletRequest request) {
        boolean result = false;
        CacheMapping mapping = this.lookupCacheMapping(request);
        if (mapping.findMethod(request.getMethod())) {
            result = true;
            ConstraintField[] fields = mapping.getConstraintFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].applyConstraints(this.context, request)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isRefreshNeeded(HttpServletRequest request) {
        Object value;
        boolean result = false;
        CacheMapping mapping = this.lookupCacheMapping(request);
        Field field = mapping.getRefreshField();
        if (field != null && (value = field.getValue(this.context, request)) != null && "true".equals(value.toString())) {
            result = true;
        }
        return result;
    }

    public int getTimeout(HttpServletRequest request) {
        Object value;
        CacheMapping mapping = this.lookupCacheMapping(request);
        int result = mapping.getTimeout();
        Field field = mapping.getTimeoutField();
        if (field != null && (value = field.getValue(this.context, request)) != null) {
            try {
                Integer timeoutAttr = new Integer(value.toString());
                result = timeoutAttr;
            }
            catch (NumberFormatException cce) {
                // empty catch block
            }
        }
        return result;
    }

    public void destroy() throws Exception {
    }

    static {
        _isTraceEnabled = false;
        _rb = null;
    }
}

