/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;

public class Debug {
    public static boolean debug;
    private static boolean debugAll;
    private static boolean debugVerbose;
    private static boolean silentMode;
    private static PrintStream ps;
    private static final String READ_ONLY_PACKET = "ReadOnlyPacket";
    private static final String READ_WRITE_PACKET = "ReadWritePacket";
    private static final String PACKET_TYPE = "imq.packetType";
    public static final String WRITING_PACKET = " -------writing packet----->";
    public static final String READING_PACKET = " <------reading packet------";
    private static boolean debugTransaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String string) {
        if (debugVerbose) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(string);
                ps.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string) {
        if (!silentMode) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(string);
                ps.flush();
            }
        }
    }

    public static void printReadPacket(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(READ_ONLY_PACKET);
        boolean bl = Debug.matchPacketType(readOnlyPacket);
        if (debugAll || string != null || bl) {
            Debug.printPacket(readOnlyPacket, READING_PACKET);
        }
    }

    public static void printWritePacket(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(READ_WRITE_PACKET);
        boolean bl = Debug.matchPacketType(readOnlyPacket);
        if (debugAll || string != null || bl) {
            Debug.printPacket(readOnlyPacket, WRITING_PACKET);
        }
    }

    public static boolean matchPacketType(ReadOnlyPacket readOnlyPacket) {
        String string = System.getProperty(PACKET_TYPE);
        boolean bl = Debug.matchPacketType(readOnlyPacket, string);
        if (!bl && debugTransaction) {
            bl = Debug.isTransactedPacket(readOnlyPacket);
        }
        return bl;
    }

    public static boolean matchPacketType(ReadOnlyPacket readOnlyPacket, String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (readOnlyPacket.getPacketType() != Integer.parseInt(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPacket(ReadOnlyPacket readOnlyPacket, String string) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(new Date().toString() + string);
            readOnlyPacket.dump(ps);
            ps.flush();
        }
    }

    public static void matchAndPrintPacket(ReadOnlyPacket readOnlyPacket, String string, String string2) {
        boolean bl = true;
        if (string != null) {
            bl = Debug.matchPacketType(readOnlyPacket, string);
        }
        if (bl) {
            Debug.printPacket(readOnlyPacket, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(Traceable traceable) {
        String string;
        String string2 = string = traceable.getClass().getName();
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        string3 = System.getProperty(string2);
        if (debugAll || string3 != null) {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println("-------- begin dump class: " + traceable.getClass().getName());
                traceable.dump(ps);
                ps.println("^^^^^^^^ end dump class: " + traceable.getClass().getName());
                ps.flush();
            }
        }
    }

    public static synchronized void printStackTrace(Exception exception) {
        if (silentMode) {
            return;
        }
        exception.printStackTrace(ps);
    }

    public static PrintStream getPrintStream() {
        return ps;
    }

    public static boolean isTransactedPacket(ReadOnlyPacket readOnlyPacket) {
        int n = readOnlyPacket.getPacketType();
        switch (n) {
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 78: 
            case 79: {
                return true;
            }
        }
        return false;
    }

    static {
        String string;
        debug = false;
        debugAll = false;
        debugVerbose = false;
        silentMode = false;
        ps = System.out;
        debugTransaction = false;
        if (System.getProperty("imq.debug") != null) {
            debug = true;
        }
        if (System.getProperty("imq.debug.all") != null) {
            debug = true;
            debugVerbose = true;
            debugAll = true;
        }
        if (System.getProperty("imq.debug.verbose") != null) {
            debug = true;
            debugVerbose = true;
        }
        if ((string = System.getProperty("imq.debug.file")) != null) {
            debug = true;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, false);
                ps = new PrintStream(fileOutputStream, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (System.getProperty("imq.silent") != null) {
            silentMode = true;
        }
        if (System.getProperty("imq.debug.transaction") != null) {
            debug = true;
            debugTransaction = true;
        }
    }
}

