/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.outbound.DestinationAdapter;
import com.sun.genericra.outbound.QueueProxy;
import com.sun.genericra.outbound.TopicProxy;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class MessageProducerProxy
implements QueueSender,
TopicPublisher {
    MessageProducer mp = null;

    public MessageProducerProxy(MessageProducer mp) {
        this.mp = mp;
    }

    public int getDeliveryMode() throws JMSException {
        return this.getProducer().getDeliveryMode();
    }

    public int getPriority() throws JMSException {
        return this.getProducer().getPriority();
    }

    public long getTimeToLive() throws JMSException {
        return this.getProducer().getTimeToLive();
    }

    public void close() throws JMSException {
        this.getProducer().close();
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.getProducer().getDisableMessageID();
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.getProducer().getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int i) throws JMSException {
        this.getProducer().setDeliveryMode(i);
    }

    public void setPriority(int i) throws JMSException {
        this.getProducer().setPriority(i);
    }

    public void setTimeToLive(long l) throws JMSException {
        this.getProducer().setTimeToLive(l);
    }

    public void setDisableMessageID(boolean b) throws JMSException {
        this.getProducer().setDisableMessageID(b);
    }

    public void setDisableMessageTimestamp(boolean b) throws JMSException {
        this.getProducer().setDisableMessageTimestamp(b);
    }

    public void send(Message msg) throws JMSException {
        Message tmp = this.unwrapDestinations(msg);
        this.getProducer().send(tmp);
    }

    public void send(Message msg, int i, int j, long l) throws JMSException {
        Message tmp = this.unwrapDestinations(msg);
        this.getProducer().send(tmp, i, j, l);
    }

    public void send(Destination dest, Message msg) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Destination tmpDest = this.unwrapDestinations(dest);
        this.getProducer().send(tmpDest, tmpMsg);
    }

    public void send(Destination dest, Message msg, int i, int j, long l) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Destination tmpDest = this.unwrapDestinations(dest);
        this.getProducer().send(tmpDest, tmpMsg, i, j, l);
    }

    public Destination getDestination() throws JMSException {
        return this.getProducer().getDestination();
    }

    public Queue getQueue() throws JMSException {
        return this.getSender().getQueue();
    }

    public void send(Queue queue, Message msg) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Queue tmpQueue = this.unwrapDestinations(queue);
        this.getSender().send(tmpQueue, tmpMsg);
    }

    public void send(Queue queue, Message msg, int i, int j, long l) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Queue tmpQueue = this.unwrapDestinations(queue);
        this.getSender().send(tmpQueue, tmpMsg, i, j, l);
    }

    public void publish(Message msg) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        this.getPublisher().publish(tmpMsg);
    }

    public void publish(Message msg, int i, int j, long l) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        this.getPublisher().publish(tmpMsg, i, j, l);
    }

    public Topic getTopic() throws JMSException {
        return this.getPublisher().getTopic();
    }

    public void publish(Topic topic, Message msg) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Topic tmpTopic = this.unwrapDestinations(topic);
        this.getPublisher().publish(tmpTopic, tmpMsg);
    }

    public void publish(Topic topic, Message msg, int i, int j, long l) throws JMSException {
        Message tmpMsg = this.unwrapDestinations(msg);
        Topic tmpTopic = this.unwrapDestinations(topic);
        this.getPublisher().publish(tmpTopic, tmpMsg, i, j, l);
    }

    private MessageProducer getProducer() {
        return this.mp;
    }

    private QueueSender getSender() {
        return (QueueSender)this.mp;
    }

    private TopicPublisher getPublisher() {
        return (TopicPublisher)this.mp;
    }

    private Message unwrapDestinations(Message msg) throws JMSException {
        Destination jmsDest;
        Destination jmsReply = msg.getJMSReplyTo();
        if (jmsReply != null) {
            msg.setJMSReplyTo(this.unwrapDestinations(jmsReply));
        }
        if ((jmsDest = msg.getJMSDestination()) != null) {
            msg.setJMSDestination(this.unwrapDestinations(jmsDest));
        }
        return msg;
    }

    private Destination unwrapDestinations(Destination dest) throws JMSException {
        if (dest instanceof DestinationAdapter || dest instanceof QueueProxy || dest instanceof TopicProxy) {
            return ((DestinationAdapter)dest)._getPhysicalDestination();
        }
        return dest;
    }

    private Queue unwrapDestinations(Queue queue) throws JMSException {
        if (queue instanceof QueueProxy) {
            return (Queue)((DestinationAdapter)queue)._getPhysicalDestination();
        }
        return queue;
    }

    private Topic unwrapDestinations(Topic topic) throws JMSException {
        if (topic instanceof TopicProxy) {
            return (Topic)((DestinationAdapter)topic)._getPhysicalDestination();
        }
        return topic;
    }
}

