/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.sun.enterprise.tools.guiframework.model.ModelManager;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;

public class ModelHandlers {
    public static final String VALUE = "value";
    public static final String FROM_SESSION = "modelFromSession";
    public static final String TO_SESSION = "modelToSession";
    public static final String MODEL_CLASS = "modelClass";
    public static final String INSTANCE_NAME = "instanceName";
    public static final String MODEL_KEY = "key";
    public static final String MODEL = "model";

    public void getModel(RequestContext reqCtx, HandlerContext handlerCtx) {
        Class<?> classname = handlerCtx.getInputValue(MODEL_CLASS);
        if (classname == null) {
            throw new IllegalArgumentException("The parameter map did not contain a parameter named 'modelClass'!");
        }
        Object instanceName = handlerCtx.getInputValue(INSTANCE_NAME);
        if (instanceName == null) {
            throw new IllegalArgumentException("The parameter map did not contain a parameter named 'instanceName'!");
        }
        boolean fromSession = false;
        boolean toSession = false;
        Boolean boolValue = (Boolean)handlerCtx.getInputValue(FROM_SESSION);
        if (boolValue != null) {
            fromSession = boolValue;
        }
        if ((boolValue = (Boolean)handlerCtx.getInputValue(TO_SESSION)) != null) {
            toSession = boolValue;
        }
        if (!(classname instanceof Class)) {
            try {
                classname = Class.forName(((Object)classname).toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        handlerCtx.setOutputValue(VALUE, reqCtx.getModelManager().getModel(classname, instanceName.toString(), fromSession, toSession));
    }

    public void registerModel(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object instanceName = handlerCtx.getInputValue(INSTANCE_NAME);
        if (instanceName == null) {
            throw new IllegalArgumentException("The parameter map did not contain a parameter named 'instanceName'!");
        }
        Model model = (Model)handlerCtx.getInputValue(MODEL);
        ModelManager modelManager = (ModelManager)reqCtx.getModelManager();
        modelManager.registerModel(instanceName.toString(), model);
    }

    public void getModelValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(MODEL_KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a parameter named 'key'!");
        }
        Model model = (Model)handlerCtx.getInputValue(MODEL);
        if (model == null) {
            this.getModel(reqCtx, handlerCtx);
            model = (Model)handlerCtx.getOutputValue(VALUE);
        }
        handlerCtx.setOutputValue(VALUE, model.getValue(key.toString()));
    }

    public void dumpModelValues(RequestContext reqCtx, HandlerContext handlerCtx) {
        Model model = (Model)handlerCtx.getInputValue(MODEL);
        if (model == null) {
            this.getModel(reqCtx, handlerCtx);
            model = (Model)handlerCtx.getOutputValue(VALUE);
        }
        if (model != null) {
            ((DefaultModel)model).dumpValues(System.out);
        }
    }

    public void setModelValue(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object key = handlerCtx.getInputValue(MODEL_KEY);
        if (key == null) {
            throw new IllegalArgumentException("The parameter map did not contain a parameter named 'key'!");
        }
        Object value = handlerCtx.getInputValue(VALUE);
        Model model = (Model)handlerCtx.getInputValue(MODEL);
        if (model != null) {
            model.setValue(key.toString(), value);
            return;
        }
        this.getModel(reqCtx, handlerCtx);
        model = (Model)handlerCtx.getOutputValue(VALUE);
        model.setValue(key.toString(), value);
    }
}

