/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.renderer.ListRendererBase;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class DropDownRenderer
extends ListRendererBase {
    private static final boolean DEBUG = false;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof DropDown)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), DropDown.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        DropDown dropDown = (DropDown)component;
        if (dropDown.isForgetValue()) {
            dropDown.setValue(null);
        }
        String[] styles = null;
        styles = dropDown.isSubmitForm() ? this.getJumpDropDownStyles(dropDown, context) : this.getDropDownStyles(dropDown, context);
        super.renderListComponent(dropDown, context, styles);
        if (dropDown.isSubmitForm()) {
            ResponseWriter writer = context.getResponseWriter();
            String id = dropDown.getClientId(context).concat("_submitter");
            RenderingUtilities.renderHiddenField((UIComponent)dropDown, writer, id, "false");
        }
    }

    private String[] getDropDownStyles(DropDown component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[10];
        styles[0] = this.getOnChangeJavaScript(component, "dropDown_changed", context);
        styles[1] = theme.getStyleClass("MENU_STANDARD");
        styles[2] = theme.getStyleClass("MENU_STANDARD_DISABLED");
        styles[3] = theme.getStyleClass("MENU_STANDARD_OPTION");
        styles[4] = theme.getStyleClass("MENU_STANDARD_OPTION_DISABLED");
        styles[5] = theme.getStyleClass("MENU_STANDARD_OPTION_SELECTED");
        styles[6] = theme.getStyleClass("MENU_STANDARD_OPTION_GROUP");
        styles[7] = theme.getStyleClass("MENU_STANDARD_OPTION_SEPARATOR");
        styles[8] = theme.getStyleClass("HIDDEN");
        return styles;
    }

    private String[] getJumpDropDownStyles(DropDown component, FacesContext context) {
        Theme theme = ThemeUtilities.getTheme(context);
        String[] styles = new String[10];
        styles[0] = this.getOnChangeJavaScript(component, "jumpDropDown_changed", context);
        styles[1] = theme.getStyleClass("MENU_JUMP");
        styles[2] = "";
        styles[3] = theme.getStyleClass("MENU_JUMP_OPTION");
        styles[4] = theme.getStyleClass("MENU_JUMP_OPTION_DISABLED");
        styles[5] = theme.getStyleClass("MENU_JUMP_OPTION_SELECTED");
        styles[6] = theme.getStyleClass("MENU_JUMP_OPTION_GROUP");
        styles[7] = theme.getStyleClass("MENU_JUMP_OPTION_SEPARATOR");
        styles[8] = theme.getStyleClass("HIDDEN");
        return styles;
    }
}

