/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.CalendarMonth;
import com.sun.web.ui.component.ComplexComponent;
import com.sun.web.ui.component.DateManager;
import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.SchedulerBase;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.component.Time;
import com.sun.web.ui.converter.DateConverter;
import com.sun.web.ui.event.IntervalListener;
import com.sun.web.ui.event.SchedulerPreviewListener;
import com.sun.web.ui.model.ClockTime;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.ScheduledEvent;
import com.sun.web.ui.model.scheduler.RepeatInterval;
import com.sun.web.ui.model.scheduler.RepeatIntervalConverter;
import com.sun.web.ui.model.scheduler.RepeatIntervalOption;
import com.sun.web.ui.model.scheduler.RepeatUnit;
import com.sun.web.ui.model.scheduler.RepeatUnitConverter;
import com.sun.web.ui.model.scheduler.RepeatUnitOption;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import com.sun.web.ui.validator.DateInRangeValidator;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.Validator;

public class Scheduler
extends SchedulerBase
implements ComplexComponent,
DateManager,
NamingContainer {
    public static final String DATE_PICKER_FACET = "datePicker";
    public static final String DATE_FACET = "date";
    public static final String DATE_LABEL_FACET = "dateLabel";
    public static final String START_DATE_TEXT_KEY = "Scheduler.startDate";
    public static final String START_TIME_FACET = "startTime";
    public static final String START_TIME_LABEL_FACET = "startTimeLabel";
    public static final String START_TIME_TEXT_KEY = "Scheduler.startTime";
    public static final String END_TIME_FACET = "endTime";
    public static final String END_TIME_LABEL_FACET = "endTimeLabel";
    public static final String END_TIME_TEXT_KEY = "Scheduler.endTime";
    public static final String REPEAT_LIMIT_UNIT_FACET = "repeatLimitUnit";
    public static final String REPEAT_UNIT_DESCRIPTION_TEXT_KEY = "Scheduler.repeatUnitDesc";
    public static final String REPEAT_LIMIT_FACET = "repeatLimit";
    public static final String REPEAT_LIMIT_LABEL_FACET = "repeatLimitLabel";
    public static final String REPEAT_LIMIT_TEXT_KEY = "Scheduler.repeatLimit";
    public static final String REPEAT_INTERVAL_FACET = "repeatInterval";
    public static final String REPEAT_INTERVAL_LABEL_FACET = "repeatIntervalLabel";
    public static final String REPEAT_INTERVAL_TEXT_KEY = "Scheduler.repeatInterval";
    public static final String REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY = "Scheduler.repeatIntervalDesc";
    public static final String PREVIEW_BUTTON_FACET = "previewButton";
    public static final String PREVIEW_BUTTON_TEXT_KEY = "Scheduler.preview";
    public static final String START_HOUR_TITLE_TEXT_KEY = "Scheduler.startHourTitle";
    public static final String START_MINUTE_TITLE_TEXT_KEY = "Scheduler.startMinuteTitle";
    public static final String END_HOUR_TITLE_TEXT_KEY = "Scheduler.endHourTitle";
    public static final String END_MINUTE_TITLE_TEXT_KEY = "Scheduler.endMinuteTitle";
    private final String END_BEFORE_START_TEXT_KEY = "Scheduler.endBeforeStart";
    private static final String INVALID_INPUT_TEXT_KEY = "Scheduler.invalidInput";
    private static final String INVALID_DATE_TEXT_KEY = "Scheduler.invalidDate";
    private static final String INVALID_START_TIME_TEXT_KEY = "Scheduler.invalidStartTime";
    private static final String INVALID_END_TIME_TEXT_KEY = "Scheduler.invalidEndTime";
    public static final String ICON_ID = "_icon";
    public static final String JAVASCRIPT_OBJECT = "_jsObject";
    private static final String VALUE_SUBMITTED = "com.sun.web.ui.SchedulerSubmitted";
    private static final String FIRST_AVAILABLE_DATE = "com.sun.web.ui.FirstAvailable";
    private static final String LAST_AVAILABLE_DATE = "com.sun.web.ui.LastAvailable";
    private static final boolean DEBUG = false;

    public CalendarMonth getDatePicker() {
        CalendarMonth dp = (CalendarMonth)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_PICKER_FACET, true);
        if (dp == null) {
            dp = new CalendarMonth();
            dp.setPopup(false);
            dp.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_PICKER_FACET));
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_PICKER_FACET, (UIComponent)dp);
        }
        dp.setJavaScriptObjectName(this.getJavaScriptObjectName(FacesContext.getCurrentInstance()));
        return dp;
    }

    public UIComponent getDateLabelComponent(Theme theme) {
        String label = this.getDateLabel();
        if (label == null) {
            label = theme.getMessage(START_DATE_TEXT_KEY);
        }
        return this.getLabelFacet(DATE_LABEL_FACET, label, this.getDateComponent());
    }

    public UIComponent getDateComponent() {
        UIComponent fieldComponent = this.getFacet(DATE_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, DATE_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, DATE_FACET));
            field.setConverter(new DateConverter());
            field.addValidator(new DateInRangeValidator());
            ComponentUtilities.putPrivateFacet((UIComponent)this, DATE_FACET, (UIComponent)field);
        }
        field.setDisabled(this.isDisabled());
        this.initFieldFacet(field, 12, this.isRequired());
        return field;
    }

    public UIComponent getStartTimeLabelComponent(Theme theme) {
        String label = this.getStartTimeLabel();
        if (label == null) {
            label = theme.getMessage(START_TIME_TEXT_KEY);
        }
        return this.getLabelFacet(START_TIME_LABEL_FACET, label, (UIComponent)this.getStartTimeComponent());
    }

    public Time getStartTimeComponent() {
        return this.getTimeFacet(START_TIME_FACET, this.isRequired(), START_HOUR_TITLE_TEXT_KEY, START_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getEndTimeLabelComponent(Theme theme) {
        String label = this.getEndTimeLabel();
        if (label == null) {
            label = theme.getMessage(END_TIME_TEXT_KEY);
        }
        return this.getLabelFacet(END_TIME_LABEL_FACET, label, (UIComponent)this.getEndTimeComponent());
    }

    public Time getEndTimeComponent() {
        return this.getTimeFacet(END_TIME_FACET, false, END_HOUR_TITLE_TEXT_KEY, END_MINUTE_TITLE_TEXT_KEY);
    }

    public UIComponent getRepeatIntervalLabelComponent() {
        String label = this.getRepeatIntervalLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_INTERVAL_TEXT_KEY);
        }
        return this.getLabelFacet(REPEAT_INTERVAL_LABEL_FACET, label, (UIComponent)this.getRepeatIntervalComponent());
    }

    public DropDown getRepeatIntervalComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_INTERVAL_FACET));
            dropDown.setSubmitForm(true);
            dropDown.setConverter(new RepeatIntervalConverter());
            dropDown.setImmediate(true);
            dropDown.addActionListener(new IntervalListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_INTERVAL_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatIntervalItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_INTERVAL_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getRepeatLimitLabelComponent() {
        String label = this.getRepeatLimitLabel();
        if (label == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            label = ThemeUtilities.getTheme(context).getMessage(REPEAT_LIMIT_TEXT_KEY);
        }
        return this.getLabelFacet(REPEAT_LIMIT_LABEL_FACET, label, this.getRepeatingFieldComponent());
    }

    public UIComponent getRepeatingFieldComponent() {
        UIComponent fieldComponent = this.getFacet(REPEAT_LIMIT_FACET);
        if (fieldComponent != null) {
            return fieldComponent;
        }
        TextField field = (TextField)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, true);
        if (field == null) {
            field = new TextField();
            field.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_FACET));
            IntegerConverter converter = new IntegerConverter();
            field.setConverter((Converter)converter);
            DoubleRangeValidator drv = new DoubleRangeValidator();
            drv.setMinimum(1.0);
            field.addValidator((Validator)drv);
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_FACET, (UIComponent)field);
        }
        this.initFieldFacet(field, 3, false);
        return field;
    }

    public DropDown getRepeatUnitComponent() {
        DropDown dropDown = (DropDown)ComponentUtilities.getPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, true);
        if (dropDown == null) {
            dropDown = new DropDown();
            dropDown.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REPEAT_LIMIT_UNIT_FACET));
            dropDown.setConverter(new RepeatUnitConverter());
            ComponentUtilities.putPrivateFacet((UIComponent)this, REPEAT_LIMIT_UNIT_FACET, (UIComponent)dropDown);
        }
        dropDown.setItems(this.getRepeatUnitItems());
        Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
        dropDown.setToolTip(theme.getMessage(REPEAT_UNIT_DESCRIPTION_TEXT_KEY));
        return dropDown;
    }

    public UIComponent getPreviewButtonComponent() {
        UIComponent buttonComponent = this.getFacet(PREVIEW_BUTTON_FACET);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, PREVIEW_BUTTON_FACET));
            button.setMini(true);
            button.setPrimary(false);
            button.setImmediate(true);
            button.addActionListener(new SchedulerPreviewListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, PREVIEW_BUTTON_FACET, (UIComponent)button);
        }
        button.setText(ThemeUtilities.getTheme(FacesContext.getCurrentInstance()).getMessage(PREVIEW_BUTTON_TEXT_KEY));
        return button;
    }

    public void updateRepeatUnitMenu() {
        if (!this.isLimitRepeating()) {
            return;
        }
        DropDown repeatIntervalComp = (DropDown)this.getPrivateFacet(REPEAT_INTERVAL_FACET);
        Object value = repeatIntervalComp.getValue();
        if (value == null || !(value instanceof RepeatInterval)) {
            this.disableRepeatLimitComponents();
        } else {
            RepeatInterval ri = (RepeatInterval)value;
            if (ri.getRepresentation().equals("ONETIME")) {
                this.disableRepeatLimitComponents();
            } else {
                this.enableRepeatLimitComponents(ri);
            }
        }
    }

    public String getPrimaryElementID(FacesContext context) {
        UIComponent comp = this.getDateComponent();
        if (comp instanceof ComplexComponent) {
            return ((ComplexComponent)comp).getPrimaryElementID(context);
        }
        return this.getDateComponent().getClientId(context);
    }

    public Object getRepeatIntervalItems() {
        Option[] optionsObject = super.getRepeatIntervalItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatIntervalOption(RepeatInterval.getInstance("ONETIME")), new RepeatIntervalOption(RepeatInterval.getInstance("HOURLY")), new RepeatIntervalOption(RepeatInterval.getInstance("DAILY")), new RepeatIntervalOption(RepeatInterval.getInstance("WEEKLY")), new RepeatIntervalOption(RepeatInterval.getInstance("MONTHLY"))};
            optionsObject = options;
            super.setRepeatIntervalItems(options);
        }
        return optionsObject;
    }

    public Object getRepeatUnitItems() {
        Option[] optionsObject = super.getRepeatUnitItems();
        if (optionsObject == null) {
            Option[] options = new Option[]{new RepeatUnitOption(RepeatUnit.getInstance("HOURS")), new RepeatUnitOption(RepeatUnit.getInstance("DAYS")), new RepeatUnitOption(RepeatUnit.getInstance("WEEKS")), new RepeatUnitOption(RepeatUnit.getInstance("MONTHS"))};
            optionsObject = options;
            super.setRepeatUnitItems(options);
        }
        return optionsObject;
    }

    public DateFormat getDateFormat() {
        return this.getDatePicker().getDateFormat();
    }

    public String getJavaScriptObjectName(FacesContext context) {
        return this.getClientId(context).replace(':', '_').concat(JAVASCRIPT_OBJECT);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.setValid(true);
        UIComponent facet = this.getPrivateFacet(DATE_PICKER_FACET);
        facet.processDecodes(context);
        this.getPreviewButtonComponent().processDecodes(context);
        this.getDateComponent().processDecodes(context);
        if (this.isStartTime()) {
            facet = this.getPrivateFacet(START_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isEndTime()) {
            facet = this.getPrivateFacet(END_TIME_FACET);
            facet.processDecodes(context);
        }
        if (this.isRepeating()) {
            facet = this.getPrivateFacet(REPEAT_INTERVAL_FACET);
            facet.processDecodes(context);
            if (this.isLimitRepeating()) {
                facet = this.getPrivateFacet(REPEAT_LIMIT_FACET);
                facet.processDecodes(context);
                facet = this.getPrivateFacet(REPEAT_LIMIT_UNIT_FACET);
                facet.processDecodes(context);
            }
        }
        this.setSubmittedValue(VALUE_SUBMITTED);
        if (this.isImmediate()) {
            this.runValidation(context);
        }
    }

    public Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        if (context == null) {
            throw new NullPointerException();
        }
        Iterator kids = this.getFacetsAndChildren();
        UIComponent kid = null;
        while (kids.hasNext()) {
            kid = (UIComponent)kids.next();
            if (!(kid instanceof EditableValueHolder) || ((EditableValueHolder)kid).isValid()) continue;
            return null;
        }
        Object dateValue = ((EditableValueHolder)this.getDateComponent()).getValue();
        Object startTimeValue = null;
        Object endTimeValue = null;
        if (this.isStartTime()) {
            startTimeValue = this.getStartTimeComponent().getValue();
        }
        if (this.isEndTime()) {
            endTimeValue = this.getEndTimeComponent().getValue();
        }
        ScheduledEvent newValue = this.createScheduledEvent(dateValue, startTimeValue, endTimeValue, context);
        if (this.isRepeating()) {
            RepeatInterval freq;
            boolean valueRepeat = false;
            Object repeatFrequency = this.getRepeatIntervalComponent().getValue();
            if (repeatFrequency != null && repeatFrequency instanceof RepeatInterval && (freq = (RepeatInterval)repeatFrequency).getCalendarField() > -1) {
                valueRepeat = true;
            }
            if (valueRepeat) {
                newValue.setRepeatingEvent(true);
                try {
                    newValue.setRepeatInterval((RepeatInterval)repeatFrequency);
                    if (this.isLimitRepeating()) {
                        Object repeatUnit = this.getRepeatUnitComponent().getValue();
                        if (repeatUnit instanceof RepeatUnit) {
                            newValue.setDurationUnit((RepeatUnit)repeatUnit);
                        } else {
                            newValue.setDurationUnit(null);
                        }
                        Object repeatLimit = ((EditableValueHolder)this.getRepeatingFieldComponent()).getValue();
                        if (repeatLimit instanceof Integer) {
                            newValue.setDuration((Integer)repeatLimit);
                        }
                        newValue.setDuration(null);
                    }
                    newValue.setDurationUnit(null);
                    newValue.setDuration(null);
                }
                catch (Exception ce) {
                    throw new ConverterException();
                }
            } else {
                newValue.setRepeatingEvent(false);
                newValue.setDurationUnit(null);
                newValue.setDuration(null);
            }
        } else {
            newValue.setRepeatingEvent(false);
            newValue.setDurationUnit(null);
            newValue.setDuration(null);
        }
        this.getDatePicker().setValue(newValue);
        return newValue;
    }

    private UIComponent getLabelFacet(String facetName, String labelText, UIComponent labeledComponent) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        label.setText(labelText);
        label.setLabeledComponent(labeledComponent);
        label.setLabelLevel(2);
        return label;
    }

    private void initFieldFacet(TextField field, int columns, boolean required) {
        field.setColumns(columns);
        field.setTrim(true);
        field.setRequired(required);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            field.setTabIndex(tindex);
        }
    }

    private Time getTimeFacet(String facetName, boolean required, String hourKey, String minutesKey) {
        Time time = (Time)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (time == null) {
            time = new Time();
            time.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)time);
        }
        time.setRequired(required);
        time.setTimeZone(this.getTimeZone());
        time.setHourTooltipKey(hourKey);
        time.setMinutesTooltipKey(minutesKey);
        return time;
    }

    private void runValidation(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    private ScheduledEvent createScheduledEvent(Object dateObject, Object startTimeObject, Object endTimeObject, FacesContext context) {
        ScheduledEvent event = null;
        String messageKey = null;
        if (!(dateObject instanceof Date)) {
            messageKey = INVALID_DATE_TEXT_KEY;
        }
        if (!(startTimeObject instanceof ClockTime)) {
            messageKey = INVALID_START_TIME_TEXT_KEY;
        }
        if (endTimeObject != null && !(endTimeObject instanceof ClockTime)) {
            messageKey = INVALID_END_TIME_TEXT_KEY;
        }
        if (messageKey == null) {
            event = new ScheduledEvent();
            Date date = (Date)dateObject;
            ClockTime startTime = (ClockTime)startTimeObject;
            event.setStartTime(this.calculateDate(date, startTime));
            if (endTimeObject != null) {
                ClockTime endTime = (ClockTime)endTimeObject;
                event.setEndTime(this.calculateDate(date, endTime));
                if (event.getEndTime().before(event.getStartTime())) {
                    messageKey = "Scheduler.endBeforeStart";
                    this.getEndTimeComponent().setValid(false);
                }
            }
        }
        if (messageKey != null) {
            String message = ThemeUtilities.getTheme(context).getMessage(messageKey);
            throw new ConverterException(new FacesMessage(message));
        }
        return event;
    }

    private Date calculateDate(Date date, ClockTime time) {
        Calendar calendar = (Calendar)this.getDatePicker().getCalendar().clone();
        calendar.setTime(date);
        calendar.set(11, time.getHour());
        calendar.set(12, time.getMinute());
        return calendar.getTime();
    }

    private void disableRepeatLimitComponents() {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setDisabled(true);
        dd.setSubmittedValue(null);
        dd.setValue(null);
        comp.getAttributes().put("disabled", Boolean.TRUE);
        ((EditableValueHolder)comp).setValue(null);
        ((EditableValueHolder)comp).setSubmittedValue(null);
    }

    private void enableRepeatLimitComponents(RepeatInterval ri) {
        DropDown dd = this.getRepeatUnitComponent();
        UIComponent comp = this.getRepeatingFieldComponent();
        dd.setValue(ri.getDefaultRepeatUnit());
        dd.setSubmittedValue(null);
        dd.setDisabled(false);
        comp.getAttributes().put("disabled", Boolean.FALSE);
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    private UIComponent getPrivateFacet(String facetName) {
        Object facet = ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, false);
        if (facet != null) {
            return facet;
        }
        if (facetName.equals(DATE_PICKER_FACET)) {
            facet = this.getDatePicker();
        } else if (facetName.equals(START_TIME_FACET)) {
            facet = this.getStartTimeComponent();
        } else if (facetName.equals(END_TIME_FACET)) {
            facet = this.getEndTimeComponent();
        } else if (facetName.equals(REPEAT_LIMIT_UNIT_FACET)) {
            facet = this.getRepeatUnitComponent();
        } else if (facetName.equals(REPEAT_INTERVAL_FACET)) {
            facet = this.getRepeatIntervalComponent();
        }
        return facet;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getSubmittedValue() != null) {
            this.updateDatePicker(context);
        } else {
            this.initializeValues(context);
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeEnd(context, (UIComponent)this);
        }
    }

    private void updateDatePicker(FacesContext context) {
        block4: {
            try {
                Object value = this.getConvertedValue(context, null);
                this.getDatePicker().setValue(value);
            }
            catch (Exception ex) {
                UIComponent comp = this.getDateComponent();
                Object value = ((EditableValueHolder)comp).getSubmittedValue();
                if (value == null) break block4;
                try {
                    Object dO = ConversionUtilities.convertValueToObject(comp, (String)value, context);
                    this.getDatePicker().setValue(dO);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
    }

    private void initializeValues(FacesContext context) {
        CalendarMonth dp = this.getDatePicker();
        Object value = this.getValue();
        if (value != null && value instanceof ScheduledEvent) {
            ScheduledEvent event = (ScheduledEvent)value;
            dp.setValue(event);
            dp.displayValue();
            ((EditableValueHolder)this.getDateComponent()).setValue((Object)event.getStartTime());
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(this.getClockTime(dp, event.getStartTime()));
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(this.getClockTime(dp, event.getEndTime()));
            }
            if (this.isRepeating()) {
                RepeatInterval ri = event.getRepeatInterval();
                this.getRepeatIntervalComponent().setValue(ri);
                if (this.isLimitRepeating()) {
                    DropDown unitDropDown = this.getRepeatUnitComponent();
                    UIComponent comp = this.getRepeatingFieldComponent();
                    if (ri == null || ri.getRepresentation().equals("ONETIME")) {
                        unitDropDown.setDisabled(true);
                        unitDropDown.setValue(null);
                        ((EditableValueHolder)comp).setValue(null);
                        comp.getAttributes().put("disabled", Boolean.TRUE);
                    } else {
                        unitDropDown.setDisabled(false);
                        unitDropDown.setValue(event.getDurationUnit());
                        ((EditableValueHolder)comp).setValue((Object)event.getDuration());
                        comp.getAttributes().put("disabled", Boolean.FALSE);
                    }
                }
            }
        } else {
            dp.setValue(null);
            ((EditableValueHolder)this.getDateComponent()).setValue(null);
            if (this.isStartTime()) {
                this.getStartTimeComponent().setValue(null);
            }
            if (this.isEndTime()) {
                this.getEndTimeComponent().setValue(null);
            }
            if (this.isRepeating()) {
                this.getRepeatIntervalComponent().setValue("ONETIME");
                if (this.isLimitRepeating()) {
                    DropDown ru = this.getRepeatUnitComponent();
                    ru.setValue(null);
                    ru.setDisabled(true);
                    EditableValueHolder rf = (EditableValueHolder)this.getRepeatingFieldComponent();
                    rf.setValue(null);
                    ((UIComponent)rf).getAttributes().put("disabled", Boolean.TRUE);
                }
            }
        }
    }

    private ClockTime getClockTime(CalendarMonth datePicker, Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = datePicker.getCalendar();
        calendar.setTime(date);
        ClockTime clockTime = new ClockTime();
        clockTime.setHour(new Integer(calendar.get(11)));
        clockTime.setMinute(new Integer(calendar.get(12)));
        return clockTime;
    }

    public Date getFirstAvailableDate() {
        Date minDate = this.getMinDate();
        if (minDate == null) {
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            minDate = calendar.getTime();
        }
        return minDate;
    }

    public Date getLastAvailableDate() {
        Date maxDate = this.getMaxDate();
        if (maxDate == null) {
            Date minDate = this.getFirstAvailableDate();
            Calendar calendar = this.getDatePicker().getCalendar();
            calendar.setTime(minDate);
            calendar.add(1, 4);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            maxDate = calendar.getTime();
        }
        return maxDate;
    }
}

