/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AddRemoveBase;
import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.ListManager;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.OptionGroup;
import com.sun.web.ui.model.Separator;
import com.sun.web.ui.model.list.ListItem;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ComponentUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.ThemeUtilities;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class AddRemove
extends AddRemoveBase
implements ListManager {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADDALL_BUTTON_ID = "_addAllButton";
    public static final String ADDALL_BUTTON_FACET = "addAllButton";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVEALL_BUTTON_ID = "_removeAllButton";
    public static final String REMOVEALL_BUTTON_FACET = "removeAllButton";
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String AVAILABLE_LABEL_ID = "_availableLabel";
    public static final String AVAILABLE_LABEL_FACET = "availableLabel";
    public static final String SELECTED_LABEL_ID = "_selectedLabel";
    public static final String SELECTED_LABEL_FACET = "selectedLabel";
    public static final String HEADER_FACET = "header";
    public static final String HEADER_ID = "_header";
    public static final String FOOTER_FACET = "footer";
    public static final String AVAILABLE_ID = "_available";
    public static final String AVAILABLE_TEXT_KEY = "AddRemove.available";
    public static final String SELECTED_ID = "_selected";
    public static final String SELECTED_TEXT_KEY = "AddRemove.selected";
    public static final String JSOBJECT = "com.sun.web.ui.AddRemoveJS";
    public static final String JAVASCRIPT_PREFIX = "javascript: ";
    public static final String RETURN = "return false;";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ADD_TEXT_KEY = "AddRemove.add";
    public static final String ADDVERTICAL_TEXT_KEY = "AddRemove.addVertical";
    public static final String ADDALL_FUNCTION = ".addAll();";
    public static final String ADDALL_TEXT_KEY = "AddRemove.addAll";
    public static final String ADDALLVERTICAL_TEXT_KEY = "AddRemove.addAllVertical";
    public static final String REMOVE_FUNCTION = ".remove(); ";
    public static final String REMOVE_TEXT_KEY = "AddRemove.remove";
    public static final String REMOVEVERTICAL_TEXT_KEY = "AddRemove.removeVertical";
    public static final String REMOVEALL_FUNCTION = ".removeAll(); ";
    public static final String REMOVEALL_TEXT_KEY = "AddRemove.removeAll";
    public static final String REMOVEALLVERTICAL_TEXT_KEY = "AddRemove.removeAllVertical";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEUP_TEXT_KEY = "AddRemove.moveUp";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String MOVEDOWN_TEXT_KEY = "AddRemove.moveDown";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String AVAILABLE_ONCHANGE_FUNCTION = ".availableOnChange(); ";
    public static final String SELECTED_ONCHANGE_FUNCTION = ".selectedOnChange(); ";
    public static final String MULTIPLEADDITIONS_FUNCTION = ".allowMultipleAdditions()";
    public static final String SPACER_STRING = "_";
    private static final String KEY_STRING = "a";
    private static final String DUP_STRING = "1";
    public static final String SEPARATOR_VALUE = "com.sun.web.ui.separator";
    private TreeMap availableItems = null;
    private TreeMap selectedItems = null;
    private Collator collator = null;
    private String allValues = "";
    private String selectedValues = "";
    private static final boolean DEBUG = false;

    public AddRemove() {
        this.setMultiple(true);
    }

    public int getRows() {
        int rows = super.getRows();
        if (rows < 1) {
            rows = 12;
        }
        return rows;
    }

    public String getSeparator() {
        return "|";
    }

    public Iterator getSelectedItems() {
        return this.selectedItems.values().iterator();
    }

    public String getAllValues() {
        return this.allValues;
    }

    public String getSelectedValues() {
        return this.selectedValues;
    }

    public UIComponent getAddButtonComponent(FacesContext context) {
        return this.getAddButtonComponent();
    }

    public UIComponent getAddButtonComponent() {
        return this.getButtonFacet(ADD_BUTTON_FACET, true, this.getTheme().getMessage(this.isVertical() ? ADDVERTICAL_TEXT_KEY : ADD_TEXT_KEY), ADD_FUNCTION);
    }

    public UIComponent getAddAllButtonComponent() {
        return this.getButtonFacet(ADDALL_BUTTON_FACET, false, this.getTheme().getMessage(this.isVertical() ? ADDALLVERTICAL_TEXT_KEY : ADDALL_TEXT_KEY), ADDALL_FUNCTION);
    }

    public UIComponent getRemoveButtonComponent() {
        return this.getButtonFacet(REMOVE_BUTTON_FACET, true, this.getTheme().getMessage(this.isVertical() ? REMOVEVERTICAL_TEXT_KEY : REMOVE_TEXT_KEY), REMOVE_FUNCTION);
    }

    public UIComponent getRemoveAllButtonComponent() {
        return this.getButtonFacet(REMOVEALL_BUTTON_FACET, false, this.getTheme().getMessage(this.isVertical() ? REMOVEALLVERTICAL_TEXT_KEY : REMOVEALL_TEXT_KEY), REMOVEALL_FUNCTION);
    }

    public UIComponent getMoveUpButtonComponent() {
        return this.getButtonFacet(MOVEUP_BUTTON_FACET, false, this.getTheme().getMessage(MOVEUP_TEXT_KEY), MOVEUP_FUNCTION);
    }

    public UIComponent getMoveDownButtonComponent() {
        return this.getButtonFacet(MOVEDOWN_BUTTON_FACET, false, this.getTheme().getMessage(MOVEDOWN_TEXT_KEY), MOVEDOWN_FUNCTION);
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, String onclickFunction) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        this.initButtonFacet(button, primary, text, onclickFunction);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text, String onclickFunction) {
        String jsobj;
        button.setPrimary(primary);
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        if ((jsobj = (String)this.getAttributes().get(JSOBJECT)) != null) {
            StringBuffer jsBuffer = new StringBuffer(200);
            jsBuffer.append(JAVASCRIPT_PREFIX);
            jsBuffer.append(jsobj);
            jsBuffer.append(onclickFunction);
            jsBuffer.append(RETURN);
            button.setOnClick(jsBuffer.toString());
        }
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getAvailableLabelComponent() {
        String labelString = this.getAvailableItemsLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(AVAILABLE_TEXT_KEY);
        }
        String arLabelText = this.getLabel();
        String styleClass = this.getLabelFacetStyleClass(arLabelText);
        int labelLevel = this.getLabelFacetLabelLevel(arLabelText);
        String forId = this.getLabelFacetForId(AVAILABLE_ID);
        return this.getLabelFacet(AVAILABLE_LABEL_FACET, labelString, styleClass, forId, labelLevel);
    }

    public UIComponent getSelectedLabelComponent() {
        String labelString = this.getSelectedItemsLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = this.getTheme().getMessage(SELECTED_TEXT_KEY);
        }
        String arLabelText = this.getLabel();
        String styleClass = this.getLabelFacetStyleClass(arLabelText);
        int labelLevel = this.getLabelFacetLabelLevel(arLabelText);
        String forId = this.getLabelFacetForId(AVAILABLE_ID);
        return this.getLabelFacet(AVAILABLE_LABEL_FACET, labelString, styleClass, forId, labelLevel);
    }

    public UIComponent getHeaderComponent() {
        String labelString = this.getLabel();
        String styleClass = this.getTheme().getStyleClass("ADDREMOVE_LABEL");
        return this.getLabelFacet(HEADER_FACET, labelString, styleClass, null, 2);
    }

    private UIComponent getLabelFacet(String facetName, String labelText, String styleClass, String forId, int labelLevel) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        if (labelText == null) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        this.initLabelFacet(label, facetName, labelText, styleClass, forId, labelLevel);
        return label;
    }

    protected void initLabelFacet(Label label, String facetName, String labelText, String styleClass, String forId, int labelLevel) {
        if (label == null) {
            return;
        }
        if (labelText == null || labelText.length() < 1) {
            labelText = new String();
        }
        label.setLabelLevel(labelLevel);
        label.setText(labelText);
        label.setStyleClass(styleClass);
        if (forId != null) {
            label.setFor(forId);
        } else {
            label.setLabeledComponent((UIComponent)this);
        }
    }

    private String getLabelFacetForId(String idSuffix) {
        return this.getClientId(FacesContext.getCurrentInstance()).concat(idSuffix);
    }

    private int getLabelFacetLabelLevel(String labelText) {
        return labelText == null || labelText.length() == 0 ? 2 : 3;
    }

    private String getLabelFacetStyleClass(String labelText) {
        String styleClass = null;
        styleClass = labelText == null || labelText.length() == 0 ? this.getTheme().getStyleClass("ADDREMOVE_LABEL") : this.getTheme().getStyleClass("ADDREMOVE_LABEL2");
        return styleClass;
    }

    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat(AVAILABLE_ID);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(3);
        this.availableItems = new TreeMap(this.collator);
        this.selectedItems = new TreeMap(this.collator);
        this.processOptions(context, this.collator, locale, rulerAtEnd);
        this.allValues = this.constructValueString(this.availableItems);
        this.processSelections();
        this.selectedValues = this.constructValueString(this.selectedItems, SEPARATOR_VALUE);
        return this.availableItems.values().iterator();
    }

    protected void processOptions(FacesContext context, Collator collator, Locale locale, boolean rulerAtEnd) {
        Option[] options = this.getOptions();
        int length = options.length;
        ListItem listItem = null;
        String label = null;
        String lastKey = "";
        String longestString = "";
        StringBuffer unsortedKeyBuffer = new StringBuffer(100);
        boolean sorted = this.isSorted();
        for (int counter = 0; counter < length; ++counter) {
            String msg;
            if (options[counter] instanceof OptionGroup) {
                msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "AddRemove.noGrouping");
                this.log(msg);
                continue;
            }
            if (options[counter] instanceof Separator) {
                msg = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "AddRemove.noGrouping");
                this.log(msg);
                continue;
            }
            label = options[counter].getLabel();
            if (label.length() > longestString.length()) {
                longestString = label;
            }
            listItem = this.createListItem(options[counter]);
            if (sorted) {
                this.availableItems.put(label, listItem);
                if (collator.compare(label, lastKey) <= 0) continue;
                lastKey = label;
                continue;
            }
            unsortedKeyBuffer.append(KEY_STRING);
            this.availableItems.put(unsortedKeyBuffer.toString(), listItem);
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int seplength = longestString.length() + 5;
            StringBuffer labelBuffer = new StringBuffer(seplength);
            for (int counter = 0; counter < seplength; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            item.setValue(SEPARATOR_VALUE);
            if (sorted) {
                lastKey = lastKey.concat(KEY_STRING);
                this.availableItems.put(lastKey, item);
                lastKey = lastKey.concat(KEY_STRING);
                this.selectedItems.put(lastKey, item);
            } else {
                unsortedKeyBuffer.append(KEY_STRING);
                this.availableItems.put(unsortedKeyBuffer.toString(), item);
                unsortedKeyBuffer.append(KEY_STRING);
                this.selectedItems.put(unsortedKeyBuffer.toString(), item);
            }
        }
    }

    private String constructValueString(TreeMap map) {
        return this.constructValueString(map, null);
    }

    private String constructValueString(TreeMap map, String filter) {
        StringBuffer valuesBuffer = new StringBuffer(392);
        Iterator values = map.values().iterator();
        ListItem listItem = null;
        String separator = this.getSeparator();
        valuesBuffer.append(separator);
        while (values.hasNext()) {
            listItem = (ListItem)values.next();
            if (filter != null && listItem.getValue().equals(filter)) continue;
            valuesBuffer.append(listItem.getValue());
            valuesBuffer.append(separator);
        }
        return valuesBuffer.toString();
    }

    public Iterator getSelectedListItems() {
        return this.selectedItems.values().iterator();
    }

    protected void markSelectedListItems(List list, boolean processed) {
        Iterator selected = list.iterator();
        boolean allowDups = this.isDuplicateSelections();
        boolean sorted = this.isSorted() && !this.isMoveButtons();
        HashMap removeItems = new HashMap();
        String selectedKey = "";
        block2: while (selected.hasNext()) {
            Object selectedValue = selected.next();
            Iterator keys = this.availableItems.keySet().iterator();
            boolean match = false;
            while (keys.hasNext()) {
                Object key = keys.next();
                Object nextItem = this.availableItems.get(key);
                ListItem listItem = null;
                try {
                    listItem = (ListItem)nextItem;
                }
                catch (Exception e) {
                    this.log("An available item was not a ListItem.");
                    continue;
                }
                match = processed ? listItem.getValueObject().equals(selectedValue) : selectedValue.toString().equals(listItem.getValue());
                if (!match) continue;
                selectedKey = sorted ? key.toString() : selectedKey.concat(KEY_STRING);
                if (removeItems.containsKey(key)) {
                    if (!allowDups) continue block2;
                    String key2 = selectedKey.toString().concat(DUP_STRING);
                    this.selectedItems.put(key2, listItem);
                    continue block2;
                }
                removeItems.put(key, null);
                this.selectedItems.put(selectedKey, listItem);
                continue block2;
            }
        }
        if (!allowDups) {
            Iterator keys = removeItems.keySet().iterator();
            Object key = null;
            while (keys.hasNext()) {
                key = keys.next();
                this.availableItems.remove(key);
            }
        }
    }

    public boolean mainListSubmits() {
        return false;
    }
}

