/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DottedNamesBase
extends AMXImplBase
implements DottedNames {
    private static final String DOTTED_NAMES = "com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support";
    protected OldDottedNamesProxy mOldDottedNamesProxy = null;
    private MBeanInfo mMBeanInfo = null;
    private Map<String, Attribute> mAttributes;
    private Set<String> mParentAttributeNames = null;
    private static final String ALL = "*";

    @Override
    public abstract Object[] dottedNameGet(String[] var1);

    @Override
    public abstract Object dottedNameGet(String var1);

    @Override
    public abstract Object[] dottedNameList(String[] var1);

    @Override
    public abstract Object[] dottedNameSet(String[] var1);

    protected abstract boolean isWriteableDottedName(String var1);

    @Override
    public boolean getMBeanInfoIsInvariant() {
        return false;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbeanInfo = null;
        if (this.getOldDottedNames() != null) {
            this.ensureMBeanInfo();
            mbeanInfo = this.mMBeanInfo;
        } else {
            mbeanInfo = super.getMBeanInfo();
        }
        return mbeanInfo;
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
        this.setupOldDottedNamesProxy();
    }

    protected void setupOldDottedNamesProxy() {
        this.setupOldDottedNamesProxy(Util.newObjectName(DOTTED_NAMES));
    }

    protected void setupOldDottedNamesProxy(ObjectName target) {
        MBeanServer server = this.getMBeanServer();
        if (!server.isRegistered(target)) {
            this.logSevere("setupOldDottedNamesProxy: old dotted names MBeans is not registered");
        }
        this.mOldDottedNamesProxy = MBeanServerInvocationHandler.newProxyInstance(server, target, OldDottedNamesProxy.class, false);
    }

    protected OldDottedNamesProxy getOldDottedNames() {
        return this.mOldDottedNamesProxy;
    }

    protected final boolean isDottedName(String name) {
        return this.getAttributes().keySet().contains(name);
    }

    protected final boolean isParentAttributeName(String name) {
        return this.mParentAttributeNames.contains(name);
    }

    protected final void filterNames(String[] in, Set<String> dotted, Set<String> parent) {
        for (int i = 0; i < in.length; ++i) {
            String name = in[i];
            if (this.isDottedName(name)) {
                dotted.add(name);
                continue;
            }
            if (!this.isParentAttributeName(name)) continue;
            parent.add(name);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        this.mCoverage.attributesWereRead(names);
        HashSet<String> dotted = new HashSet<String>();
        HashSet<String> parent = new HashSet<String>();
        this.filterNames(names, dotted, parent);
        Object[] dottedResults = this.dottedNameGet(dotted.toArray(new String[dotted.size()]));
        String[] namesForParent = new String[parent.size()];
        AttributeList parentResults = super.getAttributes(parent.toArray(namesForParent));
        AttributeList successList = new AttributeList();
        successList.addAll(parentResults);
        for (int i = 0; i < dottedResults.length; ++i) {
            if (dottedResults[i] instanceof Attribute) {
                successList.add((Attribute)dottedResults[i]);
                continue;
            }
            assert (dottedResults[i] instanceof Exception);
        }
        return successList;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        this.checkLegalName(name);
        this.mCoverage.attributeWasRead(name);
        Object result = null;
        if (this.isDottedName(name)) {
            result = this.dottedNameGet(name);
            assert (!(result instanceof Attribute));
        } else if (this.isParentAttributeName(name)) {
            result = super.getAttribute(name);
        } else {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attr.getName();
        if (this.isParentAttributeName(name)) {
            super.setAttribute(attr);
        } else {
            this.checkLegalName(name);
            this.mCoverage.attributeWasWritten(name);
            AttributeList inList = new AttributeList();
            inList.add(attr);
            AttributeList result = this.setAttributes(inList);
            if (result.size() != 1) {
                throw new InvalidAttributeValueException(attr.getName());
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        int numAttrsIn = attributes.size();
        ArrayList<String> legalPairs = new ArrayList<String>();
        for (int i = 0; i < numAttrsIn; ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            String name = attr.getName();
            this.mCoverage.attributeWasWritten(name);
            if (!this.isLegalAttributeName(name)) continue;
            legalPairs.add(DottedNamesBase.attributeToNamePair(attr));
        }
        String[] pairs = legalPairs.toArray(new String[legalPairs.size()]);
        Object[] results = this.dottedNameSet(pairs);
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof Attribute) {
                attributeList.add((Attribute)results[i]);
                continue;
            }
            assert (results[i] instanceof Exception);
        }
        return attributeList;
    }

    @Override
    public Object invokeManually(String operationName, Object[] params, String[] types) throws ReflectionException, MBeanException, NoSuchMethodException, AttributeNotFoundException {
        boolean noParams = params == null || params.length == 0;
        Object result = null;
        if (operationName.equals("refresh") && noParams) {
            this.refresh();
            result = null;
        } else {
            result = super.invokeManually(operationName, params, types);
        }
        return result;
    }

    private synchronized void ensureMBeanInfo() {
        if (this.mMBeanInfo == null) {
            this.trace("##### DottedNamesBase.ensureMBeanInfo");
            this.refresh();
            assert (this.mMBeanInfo != null);
        }
    }

    protected MBeanAttributeInfo[] buildAttributeInfos(MBeanAttributeInfo[] parentAttributeInfos) {
        String[] parentAttributeNames = JMXUtil.getAttributeNames(parentAttributeInfos);
        this.mParentAttributeNames = GSetUtil.newUnmodifiableStringSet(parentAttributeNames);
        Map<String, Attribute> attributes = this.getAttributes();
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[attributes.size() + parentAttributeInfos.length];
        int i = 0;
        for (String name : attributes.keySet()) {
            Attribute attr = attributes.get(name);
            Object value = attr.getValue();
            Class<String> theClass = value == null ? String.class : attr.getValue().getClass();
            infos[i] = new MBeanAttributeInfo(name, theClass.getName(), "", true, this.isWriteableDottedName(name), false);
            ++i;
        }
        System.arraycopy(parentAttributeInfos, 0, infos, attributes.size(), parentAttributeInfos.length);
        return infos;
    }

    protected MBeanOperationInfo[] buildOperationInfos(MBeanOperationInfo[] existing) {
        MBeanOperationInfo refreshInfo = new MBeanOperationInfo("refresh", "update MBeanInfo to reflect all available dotted names", null, Void.class.getName(), 1);
        MBeanOperationInfo[] infos = new MBeanOperationInfo[existing.length + 1];
        System.arraycopy(existing, 0, infos, 0, existing.length);
        infos[infos.length - 1] = refreshInfo;
        return infos;
    }

    protected MBeanInfo buildMBeanInfo() {
        MBeanInfo superMBeanInfo = super.getMBeanInfo();
        MBeanAttributeInfo[] attributeInfos = this.buildAttributeInfos(superMBeanInfo.getAttributes());
        MBeanOperationInfo[] operationInfos = this.buildOperationInfos(superMBeanInfo.getOperations());
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), "exposes dotted-names as Attributes", attributeInfos, superMBeanInfo.getConstructors(), operationInfos, superMBeanInfo.getNotifications());
        return info;
    }

    private static Attribute namePairToAttribute(String pair) {
        int delimIndex = pair.indexOf("=");
        assert (delimIndex >= 1);
        String name = pair.substring(0, delimIndex);
        String value = pair.substring(delimIndex + 1, pair.length());
        return new Attribute(name, value);
    }

    private static String attributeToNamePair(Attribute attr) {
        return attr.getName() + "=" + attr.getValue();
    }

    protected final boolean isLegalAttributeName(String name) {
        this.ensureAttributes();
        return this.getAttributes().keySet().contains(name) || this.mParentAttributeNames.contains(name);
    }

    protected final void ensureAttributes() {
        if (this.mAttributes == null) {
            this.refreshAttributes();
        }
    }

    protected final Map<String, Attribute> getAttributes() {
        this.ensureAttributes();
        return this.mAttributes;
    }

    protected final String[] getDottedNamesArray() {
        Map<String, Attribute> map = this.getAttributes();
        Set<String> keySet = map.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    private final void checkLegalName(String name) throws AttributeNotFoundException {
        if (!this.isLegalAttributeName(name)) {
            throw new AttributeNotFoundException("illegal attribute name: " + name);
        }
    }

    final void refreshAttributes() {
        Object result = null;
        result = this.dottedNameGet(ALL);
        Attribute[] values = (Attribute[])result;
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attr : values) {
            map.put(attr.getName(), attr);
        }
        this.mAttributes = map;
    }

    @Override
    public final void refresh() {
        this.trace("##### DottedNamesBase.refresh");
        this.refreshAttributes();
        this.mMBeanInfo = this.buildMBeanInfo();
    }

    protected static interface OldDottedNamesProxy {
        public Object[] dottedNameGet(String[] var1);

        public Object dottedNameGet(String var1);

        public Object[] dottedNameMonitoringGet(String[] var1);

        public Object dottedNameMonitoringGet(String var1);

        public String[] dottedNameList(String[] var1);

        public String[] dottedNameMonitoringList(String[] var1);

        public Object[] dottedNameSet(String[] var1);
    }
}

