/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldThreadPoolsConfigMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadPoolConfigFactory
extends ConfigFactory {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("MinThreadPoolSize", "MaxThreadPoolSize", "IdleThreadTimeoutInSeconds", "NumWorkQueues");

    public ThreadPoolConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    private OldThreadPoolsConfigMBean getOldThreadPoolsConfigMBean() {
        return this.getOldConfigProxies().getOldThreadPoolsConfigMBean(this.getConfigName());
    }

    public ObjectName create(String name, Map<String, String> optional) {
        Map<String, String> params = this.initParams(name, null, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    @Override
    public void internalRemove(ObjectName objectName) {
        String name = Util.getName(objectName);
        this.getOldThreadPoolsConfigMBean().removeThreadPoolByThreadPoolId(name);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "thread-pool-id");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        ObjectName objectName = this.getOldThreadPoolsConfigMBean().createThreadPool(translatedAttrs);
        return objectName;
    }
}

