/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConnectorConnectionPoolMBean;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public final class SecurityMapConfigFactory
extends ConfigFactory {
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";

    public SecurityMapConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    private OldConnectorConnectionPoolMBean getOld() {
        return this.getOldConfigProxies().getOldConnectorConnectionPool(this.getContainerName());
    }

    public ObjectName create(String name, String username, String password, String[] principals, String[] userGroups) {
        String containerName = this.getContainerName();
        OldConnectorConnectionPoolMBean ccp = this.getOldConfigProxies().getOldConnectorConnectionPool(containerName);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("pool_name", containerName);
        params.put("principal", principals);
        params.put("user_group", userGroups);
        AttributeList attrs = new AttributeList();
        for (String key : params.keySet()) {
            attrs.add(new Attribute(key, params.get(key)));
        }
        String targetName = null;
        this.getOld().createSecurityMap(attrs, username, password, targetName);
        ObjectName oldObjectName = ccp.getSecurityMapByName(name);
        ObjectName amxName = this.finish(oldObjectName, null);
        return amxName;
    }

    protected void removeByName(String name) {
        this.getOld().removeSecurityMapByName(name);
    }
}

