/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import java.util.logging.Level;

public class AttrClassName
extends AttrType {
    public AttrClassName(String name, String type, boolean optional) {
        super(name, type, optional);
    }

    public void validate(Object o, ValidationContext valCtx) {
        String className;
        int classStart;
        _logger.log(Level.CONFIG, "Testing attr: " + valCtx.attrName);
        super.validate(o, valCtx);
        if (o == null) {
            return;
        }
        if (o.equals("")) {
            valCtx.result.failed(valCtx.smh.getLocalString(this.getClass().getName() + ".nullClassName", "Attribute({0}=\"\" : ClassName not Valid", new Object[]{valCtx.attrName}));
        }
        if ((classStart = (className = (String)o).lastIndexOf(".")) != -1) {
            className = className.substring(classStart + 1);
        }
        if (!AttrClassName.isValidClassName(className)) {
            valCtx.result.failed(valCtx.smh.getLocalString(this.getClass().getName() + ".invalidClassName", "Attribute({0}={1}) : ClassName not Valid", new Object[]{valCtx.attrName, (String)o}));
        }
    }

    public static boolean isValidClassName(String className) {
        boolean valid = true;
        for (int i = 0; i < className.length(); ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(className.charAt(i))) {
                valid = false;
            }
            if (Character.isJavaIdentifierPart(className.charAt(i))) continue;
            valid = false;
        }
        return valid;
    }
}

