/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.transform.TransformHandler;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformMgr {
    private static TransformMgr _instance = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(TransformMgr.class);

    public static TransformMgr getInstance() {
        if (_instance == null) {
            _instance = new TransformMgr();
        }
        return _instance;
    }

    private TransformMgr() {
    }

    public void init(String appId, WebServiceConfig wsc) {
        if (wsc == null) {
            return;
        }
        try {
            if (wsc.getRequestTransformationRule() != null || wsc.getResponseTransformationRule() != null) {
                TransformHandler tHandler = new TransformHandler(wsc, appId);
                tHandler.registerFilter(wsc);
            }
        }
        catch (Exception e) {
            String msg = "Configuration initialization error.";
            _logger.log(Level.FINE, msg, e);
        }
    }

    public void stop(String appId, WebServiceConfig wsc) {
        if (wsc == null) {
            return;
        }
        try {
            if (wsc.getRequestTransformationRule() != null || wsc.getResponseTransformationRule() != null) {
                TransformHandler tHandler = new TransformHandler(wsc, appId);
                tHandler.unregisterFilter(appId, wsc);
            }
        }
        catch (Exception e) {
            String msg = "Configuration initialization error.";
            _logger.log(Level.FINE, msg, e);
        }
    }
}

