/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.transform.FilterChain;
import com.sun.enterprise.admin.wsmgmt.transform.TransformException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformFilter
implements Filter {
    private String _applicationId = null;
    private String _endpointId = null;
    private static final String DELIM = "#";
    private static final String NAME_PREFIX = "TRANSFORMFILTER_";
    private FilterChain reqChain = null;
    private FilterChain resChain = null;
    private ReentrantReadWriteLock _rwl = null;
    private Lock _readLock = null;
    private Lock _writeLock = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(TransformFilter.class);

    public TransformFilter(String appId, String endpoint) {
        this._applicationId = appId;
        this._endpointId = endpoint;
        this._rwl = new ReentrantReadWriteLock();
        this._readLock = this._rwl.readLock();
        this._writeLock = this._rwl.writeLock();
    }

    public TransformFilter(String appId, WebServiceConfig wsc) throws TransformException {
        this._applicationId = appId;
        this._endpointId = wsc.getName();
        TransformationRule[] reqRules = wsc.getRequestTransformationRule();
        if (reqRules != null) {
            this.reqChain = new FilterChain();
            this.reqChain.addFilter(reqRules, false);
        } else {
            this.reqChain = null;
        }
        TransformationRule[] resRules = wsc.getResponseTransformationRule();
        if (resRules != null) {
            this.resChain = new FilterChain();
            this.resChain.addFilter(resRules, true);
        } else {
            this.resChain = null;
        }
        this._rwl = new ReentrantReadWriteLock();
        this._readLock = this._rwl.readLock();
        this._writeLock = this._rwl.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRequestChain(TransformationRule[] tRules) throws TransformException {
        this._writeLock.lock();
        try {
            this.reqChain = new FilterChain();
            this.reqChain.addFilter(tRules, false);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResponseChain(TransformationRule[] tRules) throws TransformException {
        this._writeLock.lock();
        try {
            this.resChain = new FilterChain();
            this.resChain.addFilter(tRules, true);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public String getName() {
        return NAME_PREFIX + this._applicationId + DELIM + this._endpointId;
    }

    public static String getName(String appId, WebServiceConfig wsc) {
        return NAME_PREFIX + appId + DELIM + wsc.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String stage, String endpoint, FilterContext context) {
        this._readLock.lock();
        try {
            if (stage.equals("PROCESS_REQUEST")) {
                if (this.reqChain != null) {
                    this.reqChain.process(context);
                }
            } else if (stage.equals("PROCESS_RESPONSE") && this.resChain != null) {
                this.resChain.process(context);
            }
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("transform_failed", (Object)endpoint);
            _logger.log(Level.INFO, msg, e);
        }
        finally {
            this._readLock.unlock();
        }
    }
}

