/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigFactory;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;
import com.sun.enterprise.admin.wsmgmt.msg.EndpointHandler;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

class ApplicationMediator {
    private Map _endpoints = null;
    private String _applicationId = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(ApplicationMediator.class);

    ApplicationMediator(String id) throws MessageTraceException {
        this._applicationId = id;
        this._endpoints = new Hashtable();
        try {
            ConfigFactory cf = ConfigFactory.getConfigFactory();
            ConfigProvider cp = cf.getConfigProvider();
            WebServiceConfig[] wsc = cp.getWebserviceConfigs(id);
            for (int i = 0; i < wsc.length; ++i) {
                String mLevel = wsc[i].getMonitoringLevel();
                if (!"HIGH".equals(mLevel)) continue;
                EndpointHandler eph = new EndpointHandler(wsc[i], id);
                this._endpoints.put(eph.getEndpointName(), eph);
            }
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("ApplicationMediator_ConfigEx", (Object)id);
            throw new MessageTraceException(msg, e);
        }
    }

    void setMessageHistorySize(String wsEndpoint, int size) {
        EndpointHandler eph = (EndpointHandler)this._endpoints.get(wsEndpoint);
        if (eph != null) {
            eph.setMessageHistorySize(size);
        }
    }

    void disable(String wsEndpoint) {
        EndpointHandler eph = (EndpointHandler)this._endpoints.remove(wsEndpoint);
        if (eph != null) {
            eph.destroy();
        }
    }

    void enable(String wsEndpoint, int size) {
        EndpointHandler eph = new EndpointHandler(wsEndpoint, size, this._applicationId);
        this._endpoints.put(wsEndpoint, eph);
    }

    boolean isEmpty() {
        Collection c = this._endpoints.values();
        return c.isEmpty();
    }

    Collection getMessages(String wsEndpoint) {
        EndpointHandler eph = (EndpointHandler)this._endpoints.get(wsEndpoint);
        if (eph != null) {
            return eph.getMessages();
        }
        return null;
    }

    Collection getMessages() {
        ArrayList c = new ArrayList();
        Collection endpoints = this._endpoints.values();
        for (EndpointHandler eph : endpoints) {
            if (eph == null) continue;
            c.addAll(eph.getMessages());
        }
        return c;
    }

    void destroy() {
        Collection endpoints = this._endpoints.values();
        for (EndpointHandler eph : endpoints) {
            if (eph == null) continue;
            eph.destroy();
        }
        this._endpoints.clear();
        this._endpoints = null;
        _logger.finer("Message trace mediator destroyed for " + this._applicationId);
    }
}

