/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public final class LineTokenReplacer {
    private final TokenValue[] tokenArray;

    public LineTokenReplacer(TokenValueSet tokens) {
        Object[] tmp = tokens.toArray();
        int length = tmp.length;
        this.tokenArray = new TokenValue[length];
        System.arraycopy(tmp, 0, this.tokenArray, 0, length);
    }

    public void replace(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new BufferedWriter(new FileWriter(outputFile));
            String lineContents = null;
            while ((lineContents = reader.readLine()) != null) {
                String modifiedLine = this.replaceLine(lineContents);
                writer.write(modifiedLine);
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void replace(String inputFileName, String outputFileName) {
        this.replace(new File(inputFileName), new File(outputFileName));
    }

    private String replaceLine(String lineWithTokens) {
        String tokenFreeString = lineWithTokens;
        for (int i = 0; i < this.tokenArray.length; ++i) {
            TokenValue aPair = this.tokenArray[i];
            tokenFreeString = tokenFreeString.replaceAll(aPair.delimitedToken, aPair.value);
        }
        return tokenFreeString;
    }
}

