/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMGarbageCollectorStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMMemoryStatsImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.GarbageCollectorMXBean;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMGarbageCollectorStatsImpl
implements JVMGarbageCollectorStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMGarbageCollectorStats";
    private MutableCountStatistic collectionCount;
    private MutableCountStatistic collectionTime;
    private GarbageCollectorMXBean bean;
    private static final StringManager localStrMgr = StringManager.getManager(JVMMemoryStatsImpl.class);

    public JVMGarbageCollectorStatsImpl(GarbageCollectorMXBean gcMXBean) {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = gcMXBean;
        this.initializeStatistics();
    }

    public CountStatistic getCollectionTime() {
        long collTime = this.bean.getCollectionTime();
        this.collectionTime.setCount(collTime);
        return (CountStatistic)this.collectionTime.unmodifiableView();
    }

    public CountStatistic getCollectionCount() {
        long collCount = this.bean.getCollectionCount();
        this.collectionCount.setCount(collCount);
        return (CountStatistic)this.collectionCount.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.collection_cnt"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.collection_cnt_desc"));
        this.collectionCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.collection_time"), localStrMgr.getString("monitor.stats.milli_sec_units"), localStrMgr.getString("monitor.stats.collection_time_desc"));
        this.collectionTime = new MutableCountStatisticImpl(c);
    }
}

