/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.ContainerTypeOrApplicationType;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObject;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.EndTimeTO;
import com.sun.enterprise.admin.monitor.callflow.MethodEndTO;
import com.sun.enterprise.admin.monitor.callflow.MethodStartTO;
import com.sun.enterprise.admin.monitor.callflow.RequestEndTO;
import com.sun.enterprise.admin.monitor.callflow.RequestStartTO;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.monitor.callflow.StartTimeTO;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class AsyncHandler {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final int WAIT_INTERVALS = 100;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int BUFFER_COUNT = 6;
    private static final String THREAD_NAME = "Callflow AsyncThread";
    private LinkedBlockingQueue<RequestStartTO> requestStartQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<RequestEndTO> requestEndQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<MethodStartTO> methodStartQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<MethodEndTO> methodEndQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<StartTimeTO> startTimeQ = new LinkedBlockingQueue();
    private LinkedBlockingQueue<EndTimeTO> endTimeQ = new LinkedBlockingQueue();
    private ConcurrentLinkedQueue<RequestStartTO> requestStartFreeQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<RequestEndTO> requestEndFreeQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<MethodStartTO> methodStartFreeQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<MethodEndTO> methodEndFreeQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<StartTimeTO> startTimeFreeQ = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<EndTimeTO> endTimeFreeQ = new ConcurrentLinkedQueue();
    private AsyncThread asyncThread;

    AsyncHandler() {
    }

    synchronized void enable() {
        this.asyncThread = new AsyncThread();
        this.asyncThread.start();
    }

    synchronized void disable() {
        this.asyncThread.shutdown();
    }

    void handleRequestStart(String requestId, long timeStamp, long timeStampMillis, RequestType requestType, String callerIPAddress, String remoteUser) {
        RequestStartTO rsto = this.requestStartFreeQ.poll();
        if (rsto == null) {
            rsto = new RequestStartTO();
        }
        rsto.setRequestId(requestId);
        rsto.setTimeStamp(timeStamp);
        rsto.setTimeStampMillis(timeStampMillis);
        rsto.setRequestType(requestType);
        rsto.setIpAddress(callerIPAddress);
        boolean success = false;
        while (!success) {
            try {
                this.requestStartQ.put(rsto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    void handleRequestEnd(String requestId, long timeStamp) {
        RequestEndTO reto = this.requestEndFreeQ.poll();
        if (reto == null) {
            reto = new RequestEndTO();
        }
        reto.setRequestId(requestId);
        reto.setTimeStamp(timeStamp);
        boolean success = false;
        while (!success) {
            try {
                this.requestEndQ.put(reto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    void handleMethodStart(String requestId, long timeStamp, String methodName, ComponentType componentType, String applicationName, String moduleName, String componentName, String threadId, String transactionId, String securityId) {
        MethodStartTO msto = this.methodStartFreeQ.poll();
        if (msto == null) {
            msto = new MethodStartTO();
        }
        msto.setRequestId(requestId);
        msto.setTimeStamp(timeStamp);
        msto.setMethodName(methodName);
        msto.setComponentType(componentType);
        msto.setAppName(applicationName);
        msto.setModuleName(moduleName);
        msto.setComponentName(componentName);
        msto.setThreadId(threadId);
        msto.setTransactionId(transactionId);
        msto.setSecurityId(securityId);
        boolean success = false;
        while (!success) {
            try {
                this.methodStartQ.put(msto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    void handleMethodEnd(String requestId, long timeStamp, Throwable exception) {
        MethodEndTO meto = this.methodEndFreeQ.poll();
        if (meto == null) {
            meto = new MethodEndTO();
        }
        meto.setRequestId(requestId);
        meto.setTimeStamp(timeStamp);
        meto.setException(exception == null ? null : exception.toString());
        boolean success = false;
        while (!success) {
            try {
                this.methodEndQ.put(meto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    void handleStartTime(String requestId, long timeStamp, ContainerTypeOrApplicationType type) {
        StartTimeTO stto = this.startTimeFreeQ.poll();
        if (stto == null) {
            stto = new StartTimeTO();
        }
        stto.setRequestId(requestId);
        stto.setTimeStamp(timeStamp);
        stto.setContainerTypeOrApplicationType(type);
        boolean success = false;
        while (!success) {
            try {
                this.startTimeQ.put(stto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    void handleEndTime(String requestId, long timeStamp, ContainerTypeOrApplicationType type) {
        EndTimeTO etto = this.endTimeFreeQ.poll();
        if (etto == null) {
            etto = new EndTimeTO();
        }
        etto.setRequestId(requestId);
        etto.setTimeStamp(timeStamp);
        etto.setContainerTypeOrApplicationType(type);
        boolean success = false;
        while (!success) {
            try {
                this.endTimeQ.put(etto);
                success = true;
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "callflow.transfer_to_async_thread_interrupted", e);
            }
        }
    }

    private class AsyncThread
    extends Thread {
        private boolean shutdown;
        private int emptyBufferCount;
        private DbAccessObject dbAccessObject;

        AsyncThread() {
            this.setDaemon(true);
            this.setName(AsyncHandler.THREAD_NAME);
            this.dbAccessObject = DbAccessObjectImpl.getInstance();
        }

        void shutdown() {
            this.shutdown = true;
            while (this.emptyBufferCount < 6) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void run() {
            ArrayList<RequestStartTO> rsTransferObjects = new ArrayList<RequestStartTO>();
            ArrayList<RequestEndTO> reTransferObjects = new ArrayList<RequestEndTO>();
            ArrayList<MethodStartTO> msTransferObjects = new ArrayList<MethodStartTO>();
            ArrayList<MethodEndTO> meTransferObjects = new ArrayList<MethodEndTO>();
            ArrayList<StartTimeTO> stTransferObjects = new ArrayList<StartTimeTO>();
            ArrayList<EndTimeTO> etTransferObjects = new ArrayList<EndTimeTO>();
            while (this.emptyBufferCount < 6) {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        RequestStartTO rsto = (RequestStartTO)AsyncHandler.this.requestStartQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (rsto == null) break;
                        rsTransferObjects.add(rsto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (rsTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(rsTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.requestStartFreeQ.addAll(rsTransferObjects);
                rsTransferObjects.clear();
                for (int i = 0; i < 10000; ++i) {
                    try {
                        RequestEndTO reto = (RequestEndTO)AsyncHandler.this.requestEndQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (reto == null) break;
                        reTransferObjects.add(reto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (reTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(reTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.requestEndFreeQ.addAll(reTransferObjects);
                reTransferObjects.clear();
                for (int i = 0; i < 10000; ++i) {
                    try {
                        MethodStartTO msto = (MethodStartTO)AsyncHandler.this.methodStartQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (msto == null) break;
                        msTransferObjects.add(msto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (msTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(msTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.methodStartFreeQ.addAll(msTransferObjects);
                msTransferObjects.clear();
                for (int i = 0; i < 10000; ++i) {
                    try {
                        MethodEndTO meto = (MethodEndTO)AsyncHandler.this.methodEndQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (meto == null) break;
                        meTransferObjects.add(meto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (meTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(meTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.methodEndFreeQ.addAll(meTransferObjects);
                meTransferObjects.clear();
                for (int i = 0; i < 10000; ++i) {
                    try {
                        StartTimeTO stto = (StartTimeTO)AsyncHandler.this.startTimeQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (stto == null) break;
                        stTransferObjects.add(stto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (stTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(stTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.startTimeFreeQ.addAll(stTransferObjects);
                stTransferObjects.clear();
                for (int i = 0; i < 10000; ++i) {
                    try {
                        EndTimeTO etto = (EndTimeTO)AsyncHandler.this.endTimeQ.poll(100L, TimeUnit.MILLISECONDS);
                        if (etto == null) break;
                        etTransferObjects.add(etto);
                        continue;
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.FINE, "callflow.async_thread_interrupted", e);
                        break;
                    }
                }
                try {
                    if (etTransferObjects.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        this.dbAccessObject.insert(etTransferObjects.toArray(new TransferObject[0]));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "callflow.async_db_write_failed", e);
                }
                AsyncHandler.this.endTimeFreeQ.addAll(etTransferObjects);
                etTransferObjects.clear();
            }
        }
    }
}

