/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server;

import com.sun.enterprise.admin.jmx.remote.protocol.Version;
import java.util.logging.Logger;

public class ServerVersionMatcher {
    private static final ServerVersionMatcher matcher = new ServerVersionMatcher();
    private static final Logger logger = Logger.getLogger("com.sun.enterprise.admin.jmx.remote.finer.logger");

    private ServerVersionMatcher() {
    }

    public static ServerVersionMatcher getMatcher() {
        return matcher;
    }

    public boolean match(Version client, Version server) {
        return this.majorCompatible(client, server) && this.minorCompatible(client, server) && this.upgradeCompatible(client, server);
    }

    boolean majorCompatible(Version c, Version s) {
        int smv;
        boolean compatible = false;
        int cmv = c.getMajorVersion();
        if (cmv < (smv = s.getMajorVersion())) {
            logger.finer("S1AS JSR 160 - Using Backword compatibility, as client version: " + cmv + " is smaller than server version: " + smv);
            logger.finer("It is better to upgrade the client software");
            compatible = true;
        } else if (cmv == smv) {
            compatible = true;
        } else {
            logger.finer("S1AS JSR 160 - Version Compatibility failed, as client version: " + cmv + " is higher than server version: " + smv);
            logger.finer("Server software has to be upgraded to atleast major version: " + cmv);
            compatible = false;
        }
        return compatible;
    }

    boolean minorCompatible(Version c, Version s) {
        int smv;
        boolean compatible = false;
        int cmv = c.getMinorVersion();
        if (cmv < (smv = s.getMinorVersion())) {
            logger.finer("S1AS JSR 160 - Using Backword compatibility, as client version: " + cmv + " is smaller than server version: " + smv);
            logger.finer("It is better to upgrade the client software");
            compatible = true;
        } else if (cmv == smv) {
            compatible = true;
        } else {
            logger.finer("S1AS JSR 160 - Version Compatibility failed, as client version: " + cmv + " is higher than server version: " + smv);
            logger.finer("Server software has to be upgraded to atleast major version: " + cmv);
            compatible = false;
        }
        return compatible;
    }

    boolean upgradeCompatible(Version c, Version s) {
        String[] cud = c.getUpgradeData();
        String[] sud = s.getUpgradeData();
        boolean uc = true;
        boolean bl = uc = uc && cud.length == sud.length;
        if (uc) {
            for (int i = 0; i < cud.length; ++i) {
                if (cud[i] == null || sud[i] == null) continue;
                boolean bl2 = uc = uc && cud[i].equals(sud[i]);
                if (!uc) break;
            }
        }
        return uc;
    }
}

