/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common.domains.registry;

import com.sun.enterprise.admin.common.domains.registry.Locked;
import com.sun.enterprise.admin.common.domains.registry.LockingStore;
import com.sun.enterprise.admin.common.domains.registry.PersistentStore;
import com.sun.enterprise.admin.common.domains.registry.TimeoutException;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class Unlocked
implements LockingStore {
    private PersistentStore storeImpl;
    private static final int TIMEOUT = 3;
    private static final int ATTEMPTS = 50;

    Unlocked(PersistentStore s) {
        if (s == null) {
            throw new NullPointerException("store is null");
        }
        this.storeImpl = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object readObject() throws IOException, TimeoutException, ClassNotFoundException {
        ObjectInputStream in = null;
        Object o = null;
        try {
            in = this.getIn();
            o = in != null ? in.readObject() : null;
        }
        catch (EOFException e) {
            o = null;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return o;
    }

    public long lastModified() {
        return 0L;
    }

    public void unlock() {
    }

    public void writeObject(Object o) throws IllegalStateException, IOException, TimeoutException {
        throw new IllegalStateException("Unlocked state - writeObject() not allowed");
    }

    public void lock() throws TimeoutException, IOException {
        RandomAccessFile raf = new RandomAccessFile(this.storeImpl.getLock(), "rws");
        this.getWriteLock(raf.getChannel());
        this.storeImpl.setState(new Locked(this.storeImpl, raf));
    }

    private ObjectInputStream getIn() throws IOException {
        FileInputStream fis = new FileInputStream(this.storeImpl.getStore());
        this.getReadLock(fis.getChannel());
        if (fis.available() > 0) {
            return new ObjectInputStream(fis);
        }
        fis.close();
        return null;
    }

    private FileLock getReadLock(FileChannel ch) throws TimeoutException, IOException {
        return this.obtainLock(ch, true);
    }

    private FileLock getWriteLock(FileChannel ch) throws TimeoutException, IOException {
        return this.obtainLock(ch, false);
    }

    private FileLock obtainLock(FileChannel channel, boolean shared) throws TimeoutException, IOException {
        FileLock lock = null;
        int attempts = 0;
        try {
            while ((lock = channel.tryLock(0L, Integer.MAX_VALUE, shared)) == null && attempts++ < 50) {
                Thread.currentThread();
                Thread.sleep(3L);
            }
        }
        catch (InterruptedException e) {
            throw new TimeoutException();
        }
        if (lock == null) {
            throw new TimeoutException();
        }
        return lock;
    }
}

