/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

public class ServerInstanceStatus
extends Status {
    public static final long serialVersionUID = 7309765796199182533L;
    private boolean mDebug = false;
    private int mDebugPort = -1;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(ServerInstanceStatus.class);

    public ServerInstanceStatus() {
        super(0, Status.kInstanceRunningMsg);
    }

    public ServerInstanceStatus(int statusCode) {
        this.setStatusCodeAndStr(statusCode);
    }

    public ServerInstanceStatus(int code, String str) {
        super(code, str);
    }

    public boolean isRunning() {
        return this.mStatusCode == 0;
    }

    public void setRunning() {
        this.mStatusCode = 0;
        this.mStatusString = kInstanceRunningMsg;
    }

    public boolean isStarting() {
        return this.mStatusCode == 1;
    }

    public void setStarting() {
        this.mStatusCode = 1;
        this.mStatusString = kInstanceStartingMsg;
    }

    public boolean isStopping() {
        return this.mStatusCode == 2;
    }

    public void setStopping() {
        this.mStatusCode = 2;
        this.mStatusString = kInstanceStoppingMsg;
    }

    public boolean isNotRunning() {
        return this.mStatusCode == 3;
    }

    public void setNotRunning() {
        this.mStatusCode = 3;
        this.mStatusString = kInstanceNotRunningMsg;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    public int getDebugPort() {
        return this.mDebugPort;
    }

    public void setDebugPort(int port) {
        this.mDebugPort = port;
    }

    private void setStatusCodeAndStr(int statusCode) {
        switch (statusCode) {
            case 1: {
                this.mStatusCode = statusCode;
                this.mStatusString = Status.kInstanceStartingMsg;
                break;
            }
            case 0: {
                this.mStatusCode = statusCode;
                this.mStatusString = Status.kInstanceRunningMsg;
                break;
            }
            case 2: {
                this.mStatusCode = statusCode;
                this.mStatusString = Status.kInstanceStoppingMsg;
                break;
            }
            case 3: {
                this.mStatusCode = statusCode;
                this.mStatusString = Status.kInstanceNotRunningMsg;
                break;
            }
            default: {
                String msg = localizedStrMgr.getString("admin.common.invalid_server_instance_status_code", new String(statusCode + ""));
                throw new IllegalArgumentException(msg);
            }
        }
    }
}

