/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import java.lang.constant.Constable;
import java.util.HashMap;

public class ParamInfo {
    protected String mOperationName = null;
    protected String[] mSignature = null;
    protected Object[] mParams = null;
    protected boolean mForcePrimitives = false;
    private static final HashMap mPrimitives = ParamInfo.createPrimitivesMap();
    private static final HashMap mPrimitiveClasses = ParamInfo.createPrimitiveClassesMap();

    private static HashMap createPrimitivesMap() {
        HashMap<Class, String> primitives = new HashMap<Class, String>();
        primitives.put(Integer.class, "int");
        primitives.put(Boolean.class, "boolean");
        primitives.put(Float.class, "float");
        primitives.put(Double.class, "double");
        primitives.put(Byte.class, "byte");
        primitives.put(Character.class, "char");
        primitives.put(Short.class, "short");
        primitives.put(Long.class, "long");
        return primitives;
    }

    private static HashMap createPrimitiveClassesMap() {
        HashMap<String, Class<Constable>> primitiveClassMap = new HashMap<String, Class<Constable>>();
        primitiveClassMap.put("int", Integer.TYPE);
        primitiveClassMap.put("boolean", Boolean.TYPE);
        primitiveClassMap.put("float", Float.TYPE);
        primitiveClassMap.put("double", Double.TYPE);
        primitiveClassMap.put("byte", Byte.TYPE);
        primitiveClassMap.put("char", Character.TYPE);
        primitiveClassMap.put("short", Short.TYPE);
        primitiveClassMap.put("long", Long.TYPE);
        return primitiveClassMap;
    }

    public static Class getPrimitiveClass(String type) {
        return (Class)mPrimitiveClasses.get(type);
    }

    public void initCoercionOptions() {
        this.mForcePrimitives = false;
    }

    public ParamInfo(String operationName, Object[] params) {
        this.mOperationName = operationName;
        this.mParams = params;
        this.initCoercionOptions();
        this.mSignature = this.paramsToClassNames(params);
    }

    public ParamInfo(String operationName) {
        this(operationName, new Object[0]);
    }

    public ParamInfo(String operationName, Object param) {
        this(operationName, new Object[]{param});
    }

    public ParamInfo(String operationName, Object param1, Object param2) {
        this(operationName, new Object[]{param1, param2});
    }

    public ParamInfo(String operationName, Object param1, Object param2, Object param3) {
        this(operationName, new Object[]{param1, param2, param3});
    }

    public ParamInfo(String operationName, Object param1, Object param2, Object param3, Object param4) {
        this(operationName, new Object[]{param1, param2, param3, param4});
    }

    public String getOperationName() {
        return this.mOperationName;
    }

    public Object[] getParams() {
        return this.mParams;
    }

    public String[] getSignature() {
        return this.mSignature;
    }

    public String[] paramsToClassNames(Object[] params) {
        String[] signature = new String[params.length];
        for (int ctr = 0; ctr < params.length; ++ctr) {
            Object primitive = null;
            if (this.mForcePrimitives) {
                primitive = mPrimitives.get(params[ctr].getClass());
            }
            signature[ctr] = primitive != null ? (String)primitive : params[ctr].getClass().getName();
        }
        return signature;
    }
}

