/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;

public class ChangeStateAction
extends ProgressObjectImpl {
    public ChangeStateAction(SunTarget[] targets) {
        super(targets);
    }

    public void run() {
        ModuleType moduleType;
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        SunTarget[] targets = (SunTarget[])this.args[1];
        String moduleID = (String)this.args[2];
        CommandType newState = (CommandType)this.args[3];
        SunTarget domain = (SunTarget)this.args[4];
        StringManager localStrings = StringManager.getManager(this.getClass());
        try {
            moduleType = DeploymentClientUtils.getModuleType(dasConnection.getExistingMBeanServerConnection(), moduleID);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.unrecognized_module_type", moduleID, ioex.getMessage()), domain);
            return;
        }
        boolean state = false;
        String action = "Disable";
        if (CommandType.START.equals(newState)) {
            state = true;
            action = "Enable";
        }
        ArrayList<SunTargetModuleID> resultTargetModuleIDs = new ArrayList<SunTargetModuleID>();
        for (int i = 0; i < targets.length; ++i) {
            DeploymentStatus stat = new DeploymentStatus();
            stat.setStageDescription(localStrings.getString("enterprise.deployment.client.state_change_desc", action, moduleID));
            try {
                DeploymentClientUtils.changeStateOfModule(dasConnection.getExistingMBeanServerConnection(), moduleID, moduleType == null ? null : moduleType.toString(), targets[i], state);
                stat.setStageStatus(2);
                stat.setStageStatusMessage(localStrings.getString("enterprise.deployment.client.state_change_success", action, moduleID));
            }
            catch (Throwable ex) {
                stat.setStageException(ex);
                stat.setStageStatus(0);
                stat.setStageStatusMessage(ex.getMessage());
            }
            if (!this.checkStatusAndAddStage(targets[i], null, localStrings.getString("enterprise.deployment.client.change_state", action, moduleID, targets[i].getName()), dasConnection, stat, state)) {
                return;
            }
            resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, targets[i]));
        }
        this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
        this.targetModuleIDs = resultTargetModuleIDs.toArray(this.targetModuleIDs);
        this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.change_state_all", action), domain);
    }
}

