/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.deployment.client.RollBackAction;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;

public class ApplicationReferenceAction
extends ProgressObjectImpl {
    private static StringManager localStrings = StringManager.getManager(ApplicationReferenceAction.class);

    public ApplicationReferenceAction(SunTarget[] targets) {
        super(targets);
    }

    private void handleAppRefActionForLifeCycleModules(ConnectionSource dasConnection, SunTarget[] targetList, String id, CommandType cmd, Map options) {
        String action = CommandType.DISTRIBUTE.equals(cmd) ? "Creation" : "Removal";
        try {
            for (int i = 0; i < targetList.length; ++i) {
                DeploymentStatus stat = null;
                stat = CommandType.DISTRIBUTE.equals(cmd) ? DeploymentClientUtils.createLifecycleModuleReference(dasConnection.getExistingMBeanServerConnection(), id, targetList[i].getName(), options) : DeploymentClientUtils.removeLifecycleModuleReference(dasConnection.getExistingMBeanServerConnection(), id, targetList[i].getName());
                if (this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.change_reference", action, targetList[i].getName()), dasConnection, stat)) continue;
                return;
            }
            this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.change_reference_lifemodule", action), targetList[0]);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.change_reference_lifemodule_failed", action, ioex.getMessage()), targetList[0]);
        }
    }

    public void run() {
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        SunTarget[] targetList = (SunTarget[])this.args[1];
        String moduleID = (String)this.args[2];
        CommandType cmd = (CommandType)this.args[3];
        Map deployOptions = (Map)this.args[4];
        String action = CommandType.DISTRIBUTE.equals(cmd) ? "Creation" : "Removal";
        try {
            if (DeploymentClientUtils.isLifecycleModule(dasConnection.getExistingMBeanServerConnection(), moduleID)) {
                this.handleAppRefActionForLifeCycleModules(dasConnection, targetList, moduleID, cmd, deployOptions);
                return;
            }
            ArrayList<SunTargetModuleID> resultTargetModuleIDs = new ArrayList<SunTargetModuleID>();
            RollBackAction rollback = CommandType.DISTRIBUTE.equals(cmd) ? new RollBackAction(3, moduleID, deployOptions) : new RollBackAction(4, moduleID, deployOptions);
            for (int i = 0; i < targetList.length; ++i) {
                DeploymentStatus stat;
                if (CommandType.DISTRIBUTE.equals(cmd)) {
                    stat = DeploymentClientUtils.createApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, localStrings.getString("enterprise.deployment.client.create_reference", targetList[i].getName()), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 1);
                    DeploymentClientUtils.setResourceOptions(deployOptions, "resCreateRef", targetList[i].getName());
                    stat = DeploymentClientUtils.startApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.reference_start", targetList[i].getName()), dasConnection, stat, true);
                } else {
                    deployOptions.put("X-DeploymentMgr.Force", "false");
                    DeploymentClientUtils.setResourceOptions(deployOptions, "resDeleteRef", targetList[i].getName());
                    stat = DeploymentClientUtils.stopApplication(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    this.checkStatusAndAddStage(targetList[i], null, localStrings.getString("enterprise.deployment.client.reference_stop", targetList[i].getName()), dasConnection, stat);
                    stat = DeploymentClientUtils.deleteApplicationReference(dasConnection.getExistingMBeanServerConnection(), moduleID, targetList[i], deployOptions);
                    if (!this.checkStatusAndAddStage(targetList[i], rollback, localStrings.getString("enterprise.deployment.client.remove_reference", targetList[i].getName()), dasConnection, stat)) {
                        return;
                    }
                    rollback.addTarget(targetList[i], 3);
                }
                resultTargetModuleIDs.add(new SunTargetModuleID(moduleID, targetList[i]));
            }
            this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
            this.targetModuleIDs = resultTargetModuleIDs.toArray(this.targetModuleIDs);
            this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.change_reference_application", action), targetList[0]);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.change_reference_application_failed", action, ioex.getMessage()), targetList[0]);
            return;
        }
    }
}

