/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.editablelist;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.ListBox;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCEditableListModelInterface;
import com.sun.web.ui.view.html.CCButton;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CCEditableList
extends RequestHandlingViewBase
implements CCStateData {
    public static final String ADD_BUTTON = "addButton";
    public static final String DELETE_BUTTON = "deleteButton";
    public static final String LISTBOX = "listbox";
    public static final String TEXTFIELD = "textField";
    public static final String LISTBOXLABEL = "listboxLabel";
    public static final String TEXTBOXLABEL = "textboxLabel";
    public static final String SELECTED_TEXTFIELD = "selectedTextField";
    private CCEditableListModelInterface model = null;

    public CCEditableList(ContainerView parent, CCEditableListModelInterface model, String name) {
        super((View)parent, name);
        this.setModel(model);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(ADD_BUTTON, CCButton.class);
        this.registerChild(DELETE_BUTTON, CCButton.class);
        this.registerChild(TEXTFIELD, TextField.class);
        this.registerChild(LISTBOX, ListBox.class);
        this.registerChild(SELECTED_TEXTFIELD, HiddenField.class);
    }

    protected View createChild(String name) {
        CCButton view = null;
        if (name.equals(ADD_BUTTON)) {
            view = new CCButton((ContainerView)this, name, null);
        } else {
            if (name.equals(DELETE_BUTTON)) {
                CCButton child = new CCButton((ContainerView)this, name, null);
                child.setDisabled(true);
                return child;
            }
            if (name.equals(LISTBOX)) {
                view = new ListBox((ContainerView)this, name, null);
            } else if (name.equals(TEXTFIELD)) {
                view = new TextField((ContainerView)this, name, null);
            } else if (name.equals(SELECTED_TEXTFIELD)) {
                view = new HiddenField((ContainerView)this, name, null);
            } else if (name.equals(LISTBOXLABEL) || name.equals(TEXTBOXLABEL)) {
                view = new StaticTextField((ContainerView)this, name, null);
            } else {
                throw new IllegalArgumentException("Invalid child name [" + name + "]");
            }
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
        this.setDisplayFieldValue(SELECTED_TEXTFIELD, this.getOptions(this.getModel().getOptionList()));
        this.setDisplayFieldValue(LISTBOX, ".");
    }

    public Map getStateData() {
        this.restoreStateData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(LISTBOX, this.getOptions(this.getModel().getOptionList()));
        return map;
    }

    public void setStateData(Map map) {
        this.resetStateData();
        if (map == null) {
            return;
        }
        this.getModel().setOptionList(this.getOptions((String)map.get(LISTBOX)));
    }

    public void resetStateData() {
        this.setDisplayFieldValue(SELECTED_TEXTFIELD, null);
    }

    public void restoreStateData() {
        OptionList optionList = this.getModel().getOptionList(this);
        if (optionList != null) {
            this.getModel().setOptionList(optionList);
        }
    }

    public CCEditableListModelInterface getModel() {
        return this.model;
    }

    protected OptionList getOptions(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, "\t");
        String[] labels = new String[st.countTokens() / 2];
        String[] values = new String[st.countTokens() / 2];
        int index = 0;
        while (st.hasMoreTokens()) {
            labels[index] = st.nextToken();
            values[index] = st.nextToken();
            ++index;
        }
        return new OptionList(labels, values);
    }

    protected String getOptions(OptionList optionList) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        if (optionList != null) {
            for (int i = 0; i < optionList.size(); ++i) {
                Option option = optionList.get(i);
                if (option == null) continue;
                if (buffer.length() > 0) {
                    buffer.append("\t");
                }
                buffer.append(option.getLabel()).append("\t").append(option.getValue());
            }
        }
        return buffer.toString();
    }

    public void setModel(CCEditableListModelInterface model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.model = model;
    }
}

