/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.tree;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.HiddenField;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.taglib.html.CCHiddenTag;
import com.sun.web.ui.taglib.html.CCHrefTag;
import com.sun.web.ui.taglib.html.CCImageTag;
import com.sun.web.ui.taglib.tree.CCTreeTagBase;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCImageField;
import com.sun.web.ui.view.tree.CCDynamicTree;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCDynamicTreeTag
extends CCTreeTagBase {
    protected CCDynamicTree treeView = null;
    protected CCHrefTag hrefTag = null;
    protected CCImageTag nodeImageTag = null;
    protected CCImageTag treeImageTag = null;
    protected CCHref nodeHREF = null;
    protected CCHref turnerHREF = null;
    protected CCImageField imageField = null;
    protected boolean forwardNodeEvents = true;
    protected CCNavNodeInterface displayRoot = null;
    private static final String OPEN_TABLE = "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"";
    private static final String TD_TAG = "<td nowrap=\"nowrap\" width=\"1%\">";
    private static final String CLOSE_TD_TAG = "</td>\n";
    private static final String CLOSE_TABLE = "</table>";
    public static final String BORDER = "0";
    private String tableStyle = "TreTbl";
    private String selectedRowStyle = "TreSelRow";
    private int maxDepth = 0;
    private int elementId = 0;

    public void reset() {
        super.reset();
        this.treeView = null;
        this.hrefTag = null;
        this.nodeImageTag = null;
        this.treeImageTag = null;
        this.nodeHREF = null;
        this.turnerHREF = null;
        this.imageField = null;
        this.forwardNodeEvents = true;
        this.tableStyle = "TreTbl";
        this.selectedRowStyle = "TreSelRow";
        this.maxDepth = 0;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCDynamicTree.class);
        this.treeView = (CCDynamicTree)view;
        this.model = this.treeView.getModel();
        if (this.model == null) {
            CCDebug.trace1("Model is null.");
            return null;
        }
        this.initProperties();
        try {
            this.treeView.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getMessage());
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (this.type == 2) {
            this.tableStyle = "TreWhtTbl";
            this.selectedRowStyle = "TreWhtSelRow";
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        this.appendPageOpenHTML(buffer, pageContext);
        this.maxDepth = this.model.getVisibleMaxDepth();
        List nodes = this.model.getNodes();
        CCNavNodeInterface node = (CCNavNodeInterface)nodes.get(0);
        if (node.isRoot()) {
            --this.maxDepth;
        }
        buffer.append(OPEN_TABLE).append(this.tableStyle).append("\" title=\"").append(this.treeTitle).append("\" summary=\"").append(this.treeAltText).append("\">");
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            node = (CCNavNodeInterface)nodes.get(i);
            this.appendHTML(buffer, node, 0);
        }
        buffer.append(CLOSE_TABLE).append("\n");
        return buffer.toString();
    }

    protected void appendPageOpenHTML(NonSyncStringBuffer buffer, PageContext context) throws JspException {
        if (this.getTargetFrame() != null || this.getOpenFunctionName() != null) {
            CCHiddenTag hiddenTag = new CCHiddenTag();
            HiddenField hidden = (HiddenField)this.treeView.getChild("newurl");
            buffer.append(hiddenTag.getHTMLString(this.getParent(), this.pageContext, (View)hidden));
            String url = (String)hidden.getValue();
            if (url != null && !url.equals("")) {
                buffer.append("<script type=\"text/javascript\">");
                if (this.getOpenFunctionName() != null) {
                    buffer.append(this.getOpenFunctionName()).append("(\"").append(this.getTargetFrame()).append("\", \"").append(url).append("\");");
                } else {
                    buffer.append("window.parent.frames[\"").append(this.getTargetFrame()).append("\"].location = \"").append(url).append("\";");
                }
                buffer.append("</script>\n");
            }
        }
    }

    protected void initProperties() {
        super.initProperties();
        this.initHrefTag();
        this.nodeImageTag = new CCImageTag();
        this.nodeImageTag.setBorder(BORDER);
        this.nodeImageTag.setHeight("19");
        this.nodeImageTag.setWidth("19");
        this.nodeImageTag.setExtraHtml("class=\"TreImg\"");
        this.treeImageTag = new CCImageTag();
        this.treeImageTag.setBorder(BORDER);
        this.treeImageTag.setHeight("22");
        this.treeImageTag.setWidth("16");
    }

    private void initHrefTag() {
        this.hrefTag = new CCHrefTag();
        this.hrefTag.setStyleClass("TreLnk");
        this.hrefTag.setTabIndex(this.getTabIndex());
    }

    protected void appendRoot(NonSyncStringBuffer buffer, CCNavNodeInterface node) throws JspException {
        String spacerWidth;
        String spacerHeight = "30";
        String string = spacerWidth = this.getSpacerWidth() != null ? this.getSpacerWidth() : "5";
        if (this.type == 2) {
            buffer.append("<tr>");
            spacerHeight = "22";
        } else {
            buffer.append("<tr class=\"").append("TreRotRow").append("\">");
        }
        buffer.append("\n").append(TD_TAG).append(CCDynamicTreeTag.getImageHTMLString(CCImage.DOT, spacerHeight, spacerWidth)).append(CLOSE_TD_TAG);
        this.appendNodeHTML(buffer, node, 0);
        buffer.append("</tr>\n");
        List kids = node.getChildren();
        int numKids = kids.size();
        for (int j = 0; j < numKids; ++j) {
            this.appendHTML(buffer, (CCNavNodeInterface)kids.get(j), 0);
        }
    }

    protected void appendHTML(NonSyncStringBuffer buffer, CCNavNodeInterface node, int depth) throws JspException {
        this.initHrefTag();
        CCNavNodeInterface selection = this.model.getSelectedNode();
        if (node.isRoot()) {
            this.appendRoot(buffer, node);
            return;
        }
        CCNavNodeInterface parent = node.getParent();
        if (parent != null && parent.isRoot() && depth == 1) {
            depth = 0;
        }
        String trTag = "<tr>\n";
        if (node == selection) {
            trTag = "<tr class=\"" + this.selectedRowStyle + "\">\n";
        }
        boolean depthChanged = false;
        buffer.append(trTag).append(TD_TAG).append(CCDynamicTreeTag.getImageHTMLString(CCImage.DOT, "22", "5")).append(CLOSE_TD_TAG);
        for (int i = depth; i > 0; --i) {
            CCNavNodeInterface ancestor = this.getAncestor(node, i);
            buffer.append(TD_TAG);
            boolean lastSibling = false;
            if (ancestor.getLevel() == 0) {
                List nodes = this.model.getNodes();
                if ((CCNavNodeInterface)nodes.get(nodes.size() - 1) == ancestor) {
                    lastSibling = true;
                }
            } else {
                boolean bl = lastSibling = ancestor.getParent().getLastChild() == ancestor;
            }
            if (lastSibling) {
                buffer.append(CCDynamicTreeTag.getImageHTMLString(CCImage.TREE_BLANK, "22", "16"));
            } else {
                buffer.append(CCDynamicTreeTag.getImageHTMLString(CCImage.TREE_LINE_VERTICAL, "22", "16"));
            }
            buffer.append(CLOSE_TD_TAG);
        }
        List kids = node.getChildren();
        int numKids = kids.size();
        if (!node.getAcceptsChildren()) {
            if (node.getImage() == null) {
                node.setImage(CCImage.TREE_DOCUMENT);
            }
            this.appendObjectNode(buffer, node, depth);
            buffer.append(CLOSE_TD_TAG).append("</tr>\n");
        } else {
            this.appendContainerNode(buffer, node, depth);
            buffer.append("</tr>\n");
            if (node.getExpanded()) {
                for (int j = 0; j < numKids; ++j) {
                    this.appendHTML(buffer, (CCNavNodeInterface)kids.get(j), depth + 1);
                }
            }
        }
    }

    protected HREF getTurnerHREF(int value) throws JspException {
        if (this.turnerHREF == null) {
            View child = this.treeView.getChild("TurnerHref");
            this.checkChildType(child, HREF.class);
            this.turnerHREF = (CCHref)child;
        }
        this.turnerHREF.setValue(String.valueOf(value));
        return this.turnerHREF;
    }

    protected HREF getNodeHREF(int value) throws JspException {
        if (this.nodeHREF == null) {
            View child = this.treeView.getChild("NodeHref");
            this.checkChildType(child, HREF.class);
            this.nodeHREF = (CCHref)child;
        }
        this.nodeHREF.setValue(String.valueOf(value));
        return this.nodeHREF;
    }

    protected CCImageField getImageField(String value) throws JspException {
        if (this.imageField == null) {
            View child = this.treeView.getChild("ChildImage");
            this.checkChildType(child, CCImageField.class);
            this.imageField = (CCImageField)child;
        }
        this.imageField.setValue(value);
        return this.imageField;
    }

    protected CCNavNodeInterface getAncestor(CCNavNodeInterface n, int generation) {
        CCNavNodeInterface ancestor = null;
        for (int i = 0; i < generation; ++i) {
            n = ancestor = n.getParent();
        }
        return ancestor;
    }

    private void setBodyContent(String content) {
        try {
            CCBodyContentImpl bodyContent = new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false));
            bodyContent.print(content);
            this.hrefTag.setBodyContent(bodyContent);
        }
        catch (IOException e) {
            CCDebug.trace1(e.getMessage());
        }
    }

    protected void appendContainerNode(NonSyncStringBuffer buffer, CCNavNodeInterface node, int depth) throws JspException {
        boolean lastSibling = false;
        boolean topNode = false;
        boolean expanded = node.getExpanded();
        String a11yText = this.turnerClosedAltText;
        if (expanded) {
            a11yText = this.turnerOpenAltText;
        }
        this.treeImageTag.setTitle(a11yText);
        this.treeImageTag.setAlt(a11yText);
        this.hrefTag.setTitle(a11yText);
        String imgSrc = null;
        if (node.getLevel() == 0) {
            List nodes = this.model.getNodes();
            if ((CCNavNodeInterface)nodes.get(0) == node && !node.isRoot()) {
                topNode = true;
            }
            if ((CCNavNodeInterface)nodes.get(nodes.size() - 1) == node) {
                lastSibling = true;
            }
        } else {
            boolean bl = lastSibling = node.getParent().getLastChild() == node;
        }
        imgSrc = lastSibling ? (expanded ? (topNode ? CCImage.TREE_HANDLE_DOWN_TOP_NOSIBLING : CCImage.TREE_HANDLE_DOWN_LAST) : (topNode ? CCImage.TREE_HANDLE_RIGHT_TOP_NOSIBLING : CCImage.TREE_HANDLE_RIGHT_LAST)) : (expanded ? (topNode ? CCImage.TREE_HANDLE_DOWN_TOP : CCImage.TREE_HANDLE_DOWN_MIDDLE) : (topNode ? CCImage.TREE_HANDLE_RIGHT_TOP : CCImage.TREE_HANDLE_RIGHT_MIDDLE));
        buffer.append(TD_TAG);
        this.setBodyContent(this.treeImageTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getImageField(imgSrc)));
        this.treeImageTag.setTitle(null);
        this.treeImageTag.setAlt(null);
        this.setHrefStatus(this.hrefTag, a11yText);
        CCNavNodeInterface selection = this.model.getSelectedNode();
        if (node == selection) {
            this.hrefTag.setStyleClass("TreSelLnk");
        }
        this.hrefTag.setElementId(this.getTurnerHREF(node.getId()).getQualifiedName() + ".Id" + this.elementId++);
        buffer.append(this.hrefTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getTurnerHREF(node.getId())));
        buffer.append(CLOSE_TD_TAG);
        this.appendNodeHTML(buffer, node, depth);
    }

    protected void appendObjectNode(NonSyncStringBuffer buffer, CCNavNodeInterface node, int depth) throws JspException {
        List nodes;
        String imgSrc = null;
        imgSrc = node.getLevel() == 0 ? ((CCNavNodeInterface)(nodes = this.model.getNodes()).get(0) == node ? CCImage.TREE_LINE_FIRST_NODE : ((CCNavNodeInterface)nodes.get(nodes.size() - 1) == node ? CCImage.TREE_LINE_LAST_NODE : CCImage.TREE_LINE_MIDDLE_NODE)) : (node.getParent() != null && node.getParent().getLastChild() == node ? CCImage.TREE_LINE_LAST_NODE : CCImage.TREE_LINE_MIDDLE_NODE);
        buffer.append(TD_TAG).append(this.treeImageTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getImageField(imgSrc)));
        buffer.append(CLOSE_TD_TAG);
        this.appendNodeHTML(buffer, node, depth);
    }

    protected void appendNodeHTML(NonSyncStringBuffer buffer, CCNavNodeInterface node, int depth) throws JspException {
        CCNavNodeInterface selectedNode = this.model.getSelectedNode();
        boolean isSelected = node == selectedNode;
        boolean notClickable = node instanceof CCNavNode ? ((CCNavNode)node).getNotClickable() : false;
        Object a11yText = null;
        String imageHtml = null;
        int severity = 5;
        this.initHrefTag();
        if (node.getImage() != null && node.getImage().equals(CCImage.DOT)) {
            int colsToSpan = 2;
            if (node.isRoot() && this.maxDepth <= 0) {
                colsToSpan = 2;
            } else if (this.maxDepth - depth > 0) {
                colsToSpan = this.maxDepth - depth + 2;
                if (node.isRoot()) {
                    ++colsToSpan;
                }
            }
            buffer.append("<td nowrap=\"nowrap\" colspan=\"").append(colsToSpan).append("\">");
        } else {
            String badgeSrc;
            buffer.append(TD_TAG);
            if ((node.getChildren().size() > 0 || node.getAcceptsChildren()) && node.getImage() == null) {
                badgeSrc = CCImage.TREE_FOLDER;
                severity = this.getMaximumChildSeverity(node);
                switch (severity) {
                    case 2: {
                        badgeSrc = CCImage.TREE_FOLDER_ALARM_CRITICAL;
                        break;
                    }
                    case 1: {
                        badgeSrc = CCImage.TREE_FOLDER_ALARM_DOWN;
                        break;
                    }
                    case 3: {
                        badgeSrc = CCImage.TREE_FOLDER_ALARM_MAJOR;
                        break;
                    }
                    case 4: {
                        badgeSrc = CCImage.TREE_FOLDER_ALARM_MINOR;
                        break;
                    }
                }
                this.setNodeA11yText(node, severity);
                imageHtml = this.nodeImageTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getImageField(badgeSrc));
                this.setBodyContent(imageHtml);
            } else {
                severity = node.getAlarmSeverity();
                this.setNodeA11yText(node, severity);
                if (severity == 5) {
                    imageHtml = this.nodeImageTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getImageField(this.getMessage(node.getImage())));
                } else {
                    badgeSrc = this.getBadgeSrc(this.getMessage(node.getImage()), severity, 9, 9);
                    imageHtml = this.nodeImageTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getImageField(badgeSrc));
                }
            }
            this.nodeImageTag.setAlt(null);
            this.nodeImageTag.setTitle(null);
            if (isSelected || notClickable) {
                buffer.append(imageHtml);
            } else {
                this.setBodyContent(imageHtml);
                if (node.getStatus() != null) {
                    this.setHrefStatus(this.hrefTag, this.getMessage(node.getStatus()));
                } else {
                    this.setHrefStatus(this.hrefTag, this.getMessage(node.getLabel()));
                }
                this.hrefTag.setOnClick(node.getOnClick());
                String ut = this.getUseNodeTarget();
                if (ut.equals("true") && node.getTarget() != null) {
                    this.hrefTag.setTarget(node.getTarget());
                }
                buffer.append(this.hrefTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getNodeHREF(node.getId())));
            }
        }
        if (node.getImage() == null || !node.getImage().equals(CCImage.DOT)) {
            int colsToSpan = 1;
            if (node.isRoot() && this.maxDepth <= 0) {
                colsToSpan = 2;
            } else if (this.maxDepth - depth > 0) {
                colsToSpan = this.maxDepth - depth + 1;
                if (node.isRoot()) {
                    ++colsToSpan;
                }
            }
            if (colsToSpan > 1) {
                buffer.append(CLOSE_TD_TAG).append("<td nowrap=\"nowrap\" colspan=\"").append(colsToSpan).append("\" width=\"99%\">");
            } else {
                buffer.append(CLOSE_TD_TAG).append("<td nowrap=\"nowrap\" width=\"99%\">");
            }
        }
        String nodeLabel = HtmlUtil.escape((String)this.getMessage(node.getLabel()));
        buffer.append("<div class=\"").append("TreLnkSpc").append("\"").append(">");
        if (isSelected) {
            buffer.append("<span class=\"").append("TreSelTxt").append("\">").append(nodeLabel).append("</span>");
        } else if (notClickable) {
            buffer.append(nodeLabel);
        } else {
            this.setBodyContent(nodeLabel);
            if (selectedNode != null && !node.isRoot() && !node.getExpanded() && node.isNodeDescendant(selectedNode)) {
                this.hrefTag.setStyleClass("TreParLnk");
            }
            buffer.append(this.hrefTag.getHTMLString(this.getParent(), this.pageContext, (View)this.getNodeHREF(node.getId())));
            this.hrefTag.setStyleClass("TreLnk");
        }
        buffer.append("</div></td>\n");
    }

    private void setNodeA11yText(CCNavNodeInterface node, int severity) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        switch (severity) {
            case 2: {
                buffer.append(this.criticalAlarmAltText).append(" ");
                break;
            }
            case 1: {
                buffer.append(this.downAlarmAltText).append(" ");
                break;
            }
            case 3: {
                buffer.append(this.majorAlarmAltText).append(" ");
                break;
            }
            case 4: {
                buffer.append(this.minorAlarmAltText).append(" ");
                break;
            }
        }
        if (node.getTooltip() != null) {
            buffer.append(node.getTooltip());
        } else {
            buffer.append(node.getLabel());
        }
        String a11yText = buffer.toString();
        this.nodeImageTag.setTitle(a11yText);
        this.nodeImageTag.setAlt(a11yText);
        this.hrefTag.setTitle(a11yText);
    }

    private void setHrefStatus(CCHrefTag ccHrefTag, String status) throws JspException {
        if (ccHrefTag == null) {
            CCDebug.trace1("CCHrefTag parameter is null.");
            return;
        }
        if (status == null) {
            CCDebug.trace1("status parameter is null.");
            return;
        }
        NonSyncStringBuffer statusBuffer = new NonSyncStringBuffer(8192);
        statusBuffer.append("window.status='").append(CCDynamicTreeTag.escapeJsQuotes(status)).append("'; return true;");
        ccHrefTag.setOnMouseOver(statusBuffer.toString());
        ccHrefTag.setOnMouseOut("window.status=''; return true;");
        ccHrefTag.setOnBlur("window.status=''; return true;");
    }

    public void setOpenFunctionName(String value) {
        this.setValue("openFunctionName", value);
    }

    public String getOpenFunctionName() {
        return (String)this.getValue("openFunctionName");
    }
}

