/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CCDefaultEntityResolver
implements EntityResolver,
Serializable {
    protected static final String DTD_DIR = "dtd";
    protected static final String TAG_DIR = "tags";
    protected static final String CCC_DIR = "com_sun_web_ui";
    private static final String FILE_PROTOCOL = "file://";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String DTD_SUFFIX = ".dtd";
    private static final String LOCAL_HOST = "localhost";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static String xmlEncoding = "UTF-8";
    private String httpPort = CCSystem.getUnsecurePort();
    private String httpHost = CCSystem.getUnsecureServerName();
    private String httpPrefix = null;
    private String userDir = null;
    private String resourceContextName = null;
    private ServletContext context = null;

    public CCDefaultEntityResolver() {
        if (this.httpPort == null || this.httpHost == null || this.httpHost.length() == 0) {
            try {
                RequestContext reqContext = RequestManager.getRequestContext();
                HttpServletRequest request = reqContext.getRequest();
                if (request.getScheme().equalsIgnoreCase("http")) {
                    this.httpHost = request.getServerName();
                    this.httpPort = Integer.toString(request.getServerPort());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.httpHost != null && this.httpPort != null) {
            this.httpPrefix = HTTP_PROTOCOL + this.httpHost + ":" + this.httpPort;
        }
        this.userDir = System.getProperty("user.dir");
        this.userDir = this.userDir.replace('\\', '/');
        this.resourceContextName = CCSystem.getResourceContextPath();
        if (this.resourceContextName.startsWith("/")) {
            this.resourceContextName = this.resourceContextName.substring(1);
        }
        if (this.httpHost == null || this.httpPort == null) {
            CCDebug.trace1("Unable to determine unsecure host and port, unsecure host: " + (this.httpHost == null ? "null" : this.httpHost) + ", unsecure port: " + (this.httpPort == null ? "null" : this.httpPort));
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String path = this.getSystemId(systemId);
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        int count = st.countTokens();
        if (count != 1 && count != 3) {
            return null;
        }
        String[] tokens = new String[count];
        for (int i = 0; i < count; ++i) {
            tokens[i] = st.nextToken();
        }
        InputSource isrc = null;
        try {
            String dtdPath = null;
            if (this.httpPrefix == null || !CCSystem.isAppInConsole()) {
                RequestContext reqContext = RequestManager.getRequestContext();
                this.context = reqContext.getServletContext();
                dtdPath = count == 1 && tokens[0].endsWith(DTD_SUFFIX) ? CCSystem.getURLPrefix() + "/" + DTD_DIR + "/" + tokens[0] : (count == 3 && tokens[1].equals(DTD_DIR) && tokens[2].endsWith(DTD_SUFFIX) ? "/" + tokens[0] + "/" + DTD_DIR + "/" + tokens[2] : path);
                InputStream is = this.context.getResourceAsStream(dtdPath);
                if (is != null) {
                    isrc = new InputSource(is);
                    return isrc;
                }
            }
        }
        catch (Exception e) {
            CCDebug.trace3("exception while getting from inputStream", e);
        }
        if (this.httpPrefix == null) {
            return null;
        }
        try {
            if (count == 1) {
                if (tokens[0].endsWith(DTD_SUFFIX)) {
                    isrc = this.buildInputSource(this.resourceContextName, tokens[0]);
                }
            } else if (count == 3 && tokens[1].equals(DTD_DIR) && tokens[2].endsWith(DTD_SUFFIX)) {
                isrc = tokens[0].equals(CCC_DIR) ? this.buildInputSource(this.resourceContextName, tokens[2]) : (tokens[0].equals(TAG_DIR) ? this.buildInputSource(this.resourceContextName, tokens[2]) : this.buildInputSource(tokens[0], tokens[2]));
            }
        }
        catch (Exception e) {
            CCDebug.trace1("cannot convert DTD, using default behaviour: " + e.getMessage());
            isrc = null;
        }
        return isrc;
    }

    protected String getSystemId(String systemId) {
        int k;
        String path;
        if (systemId == null) {
            return null;
        }
        CCDebug.trace3("entity resolver systemid: " + systemId);
        try {
            path = URLDecoder.decode(systemId, xmlEncoding);
        }
        catch (Exception ex) {
            path = systemId;
        }
        int j = path.indexOf(47);
        if (j > 0 && (k = path.indexOf(58)) >= 0 && k < j) {
            if (!path.startsWith(FILE_PROTOCOL)) {
                return null;
            }
            path = path.substring(FILE_PROTOCOL.length());
            if (this.userDir != null) {
                if (path.startsWith(this.userDir)) {
                    path = path.substring(this.userDir.length());
                } else if (path.startsWith("/" + this.userDir)) {
                    path = path.substring(this.userDir.length() + 1);
                }
            }
        }
        return path;
    }

    protected String getHostName() {
        return this.httpHost;
    }

    protected String getPortNumber() {
        return this.httpPort;
    }

    private InputSource buildInputSource(String path, String file) {
        String str;
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(128);
        buffer.append(this.httpPrefix);
        try {
            str = URLEncoder.encode(path, xmlEncoding);
        }
        catch (Exception ex) {
            str = path;
        }
        buffer.append("/" + str);
        buffer.append("/dtd");
        try {
            str = URLEncoder.encode(file, xmlEncoding);
        }
        catch (Exception ex) {
            str = file;
        }
        buffer.append("/" + str);
        String url = buffer.toString();
        CCDebug.trace3("Converted systemid: " + url);
        return new InputSource(url);
    }
}

