/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import org.xml.sax.EntityResolver;

public class CCPrivateConfiguration {
    private static final int MAXIMUM_PORT = 32768;

    public static void setSecurePort(int port) throws IllegalArgumentException {
        if (port <= 0 || port >= 32768) {
            CCDebug.trace1("Private config: invalid secure port: " + port);
            throw new IllegalArgumentException("Invalid port number");
        }
        CCSystem.setSecurePort(port);
    }

    public static void setUnsecurePort(int port) throws IllegalArgumentException {
        if (port <= 0 || port >= 32768) {
            CCDebug.trace1("Private config: invalid unsecure port: " + port);
            throw new IllegalArgumentException("Invalid port number");
        }
        CCSystem.setUnsecurePort(port);
    }

    public static void setUnsecureServerName(String name) {
        String val = null;
        if (name != null && name.length() > 0) {
            val = name;
        }
        CCSystem.setUnsecureServerName(val);
    }

    public static void setEntityResolver(EntityResolver resolver) {
        CCSystem.setEntityResolver(resolver);
    }

    public static void setSecureHelp(boolean bSecure) {
        CCSystem.setSecureHelp(bSecure);
    }

    private CCPrivateConfiguration() {
    }
}

