/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.taglib.DisplayFieldTagBase;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ViewBeanBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public abstract class AbstractVisualBodyTag
extends DisplayFieldTagBase
implements BodyTag {
    private BodyContent bodyContent = null;
    private NonSyncStringBuffer buffer = null;
    private boolean displaying = false;
    private CompleteRequestException abortedException;

    public void reset() {
        super.reset();
        this.bodyContent = null;
        this.buffer = null;
        this.setDisplaying(false);
        this.abortedException = null;
    }

    public int doStartTag() throws JspException {
        this.reset();
        try {
            if (this.fireBeginDisplayEvent()) {
                this.buffer = new NonSyncStringBuffer(256);
                this.generateStartTagContent(this.buffer);
                this.setDisplaying(true);
            } else {
                this.setDisplaying(false);
            }
        }
        catch (CompleteRequestException e) {
            this.abortedException = e;
            return 0;
        }
        if (this.isDisplaying()) {
            return 2;
        }
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.abortedException != null) {
                throw this.abortedException;
            }
            if (this.isDisplaying()) {
                this.generateBodyContent(this.buffer);
                this.generateEndTagContent(this.buffer);
                this.writeOutput(this.fireEndDisplayEvent(this.buffer.toString()));
            }
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    protected abstract void generateStartTagContent(NonSyncStringBuffer var1) throws JspException;

    protected abstract void generateBodyContent(NonSyncStringBuffer var1) throws JspException;

    protected abstract void generateEndTagContent(NonSyncStringBuffer var1) throws JspException;

    protected boolean isDisplaying() {
        return this.displaying;
    }

    private void setDisplaying(boolean value) {
        this.displaying = value;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }
}

