/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.Log;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelReference;
import com.iplanet.jato.model.ModelReferenceException;
import com.iplanet.jato.util.ClassUtil;

public class SimpleModelReference
implements ModelReference {
    private transient Model model;
    private Class modelClass;
    private String modelClassName;
    private String instanceName;
    private boolean lookInSession;
    private boolean storeInSession;

    public SimpleModelReference() {
    }

    public SimpleModelReference(Model model) {
        this();
        this.model = model;
    }

    public SimpleModelReference(String className) {
        this(className, null, false, false);
    }

    public SimpleModelReference(String className, String instanceName) {
        this(className, instanceName, false, false);
    }

    public SimpleModelReference(String className, String instanceName, boolean lookInSession, boolean storeInSession) {
        this();
        this.modelClassName = className;
        this.instanceName = instanceName;
        this.lookInSession = lookInSession;
        this.storeInSession = storeInSession;
    }

    public SimpleModelReference(Class modelClass) {
        this(modelClass, null, false, false);
    }

    public SimpleModelReference(Class modelClass, String instanceName) {
        this(modelClass, instanceName, false, false);
    }

    public SimpleModelReference(Class modelClass, String instanceName, boolean lookInSession, boolean storeInSession) {
        this();
        this.modelClass = modelClass;
        this.instanceName = instanceName;
        this.lookInSession = lookInSession;
        this.storeInSession = storeInSession;
    }

    public String getModelClassName() {
        if (this.model != null) {
            return this.model.getClass().getName();
        }
        return this.modelClassName;
    }

    public void setModelClassName(String value) {
        if (this.model != null) {
            throw new IllegalArgumentException("Cannot set the model class name: the reference has already been resolved and a model instance already obtained");
        }
        this.modelClassName = value;
        this.modelClass = null;
    }

    public Class getModelClass() {
        if (this.model != null) {
            return this.model.getClass();
        }
        if (this.modelClass == null && this.getModelClassName() != null) {
            try {
                this.modelClass = ClassUtil.getClass(this.getModelClassName());
            }
            catch (ClassNotFoundException e) {
                Log.log(8, "Unable to load model class \"" + this.getModelClassName() + "\"");
            }
        }
        if (this.modelClass == null) {
            this.modelClass = this.getDefaultModelClass();
        }
        return this.modelClass;
    }

    public void setModelClass(Class value) {
        if (this.model != null) {
            throw new IllegalArgumentException("Cannot set the model class: the reference has already been resolved and a model instance already obtained");
        }
        this.modelClass = value;
        this.modelClassName = value != null ? value.getName() : null;
    }

    protected Class getDefaultModelClass() {
        return null;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String value) {
        this.instanceName = value;
    }

    public boolean getLookInSession() {
        return this.lookInSession;
    }

    public void setLookInSession(boolean value) {
        this.lookInSession = value;
    }

    public boolean getStoreInSession() {
        return this.storeInSession;
    }

    public void setStoreInSession(boolean value) {
        this.storeInSession = value;
    }

    protected Model resolve(RequestContext requestContext) throws ModelReferenceException {
        if (requestContext == null) {
            throw new IllegalArgumentException("Parameter \"requestContext\" cannot be null");
        }
        if (this.getModelClass() == null) {
            throw new ModelReferenceException("Model class was null because it was either not specified or could not be resolved");
        }
        ModelManager modelManager = requestContext.getModelManager();
        String modelInstanceName = this.getInstanceName();
        if (modelInstanceName == null) {
            modelInstanceName = modelManager.getDefaultModelInstanceName(this.getModelClass());
        }
        return modelManager.getModel(this.getModelClass(), modelInstanceName, this.getLookInSession(), this.getStoreInSession());
    }

    public Model getModel() throws ModelReferenceException {
        if (this.model == null) {
            this.model = this.resolve(RequestManager.getRequestContext());
            if (this.model == null) {
                throw new ModelReferenceException("Could not resolve model reference, resolve() method returned null");
            }
        }
        return this.model;
    }

    public void setModel(Model value) {
        this.model = value;
        if (value != null) {
            this.setModelClass(value.getClass());
            this.setModelClassName(value.getClass().getName());
        } else {
            this.setModelClass(null);
            this.setModelClassName(null);
        }
    }

    public void clear() {
        this.model = null;
    }
}

