/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.BeanPropertyFieldDescriptor;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.DatasetModelExecutionContextImpl;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.ModelFieldGroup;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.TypeConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class BeanAdapterModel
implements DatasetModel,
RetrievingModel,
RequestParticipant,
Serializable {
    public static final int UNDEFINED_ROW_INDEX = -1;
    public static final int BEAN_SCOPE_NONE = 0;
    public static final int BEAN_SCOPE_REQUEST = 1;
    public static final int BEAN_SCOPE_SESSION = 2;
    public static final int BEAN_SCOPE_APPLICATION = 4;
    public static final int BEAN_SCOPE_ANY = 7;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private String name;
    private Object[] beans;
    private int index;
    private int locationOffset = 0;
    private Class beanClass;
    private ModelFieldGroup fieldGroup;
    private transient RequestContext requestContext;
    private int scope = 0;
    private String scopeAttributeName;
    private boolean beansSetManually;

    public BeanAdapterModel() {
        this.beans = EMPTY_OBJECT_ARRAY;
    }

    public BeanAdapterModel(Object bean) {
        this.beans = new Object[]{bean};
    }

    public BeanAdapterModel(Object[] beans) {
        this.beans = beans;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext value) {
        this.requestContext = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Object getBean() {
        if (!this.beansSetManually && this.beans.length == 0) {
            this.beans = this.findBeans();
            if (this.beans == null) {
                this.beans = EMPTY_OBJECT_ARRAY;
            }
        }
        if (this.beans.length > 0) {
            return this.beans[0];
        }
        return null;
    }

    public Object[] getBeans() {
        if (!this.beansSetManually && this.beans.length == 0) {
            this.beans = this.findBeans();
            if (this.beans == null) {
                this.beans = EMPTY_OBJECT_ARRAY;
            }
        }
        return this.beans;
    }

    public void setBean(Object value) {
        if (value != null) {
            this.beans = new Object[]{value};
            this.beansSetManually = true;
        } else {
            this.beans = EMPTY_OBJECT_ARRAY;
            this.beansSetManually = false;
        }
        this.setIndex(-1);
    }

    public void setBeans(Object[] value) {
        if (value != null) {
            this.beans = value;
            this.beansSetManually = true;
        } else {
            this.beans = EMPTY_OBJECT_ARRAY;
            this.beansSetManually = false;
        }
        this.setIndex(-1);
    }

    public int getBeanScope() {
        return this.scope;
    }

    public void setBeanScope(int value) {
        this.scope = value;
    }

    public String getBeanScopeAttributeName() {
        return this.scopeAttributeName;
    }

    public void setBeanScopeAttributeName(String value) {
        this.scopeAttributeName = value;
    }

    protected Object[] findBeans() {
        if (this.getBeanScope() == 0 || this.getBeanScopeAttributeName() == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object result = null;
        if ((this.getBeanScope() & 1) > 0) {
            result = this.getRequestContext().getRequest().getAttribute(this.getBeanScopeAttributeName());
        }
        if (result == null && (this.getBeanScope() & 2) > 0) {
            result = this.getRequestContext().getRequest().getSession().getAttribute(this.getBeanScopeAttributeName());
        }
        if (result == null && (this.getBeanScope() & 4) > 0) {
            result = this.getRequestContext().getServletContext().getAttribute(this.getBeanScopeAttributeName());
        }
        if (result != null) {
            if (result.getClass().isArray()) {
                return (Object[])result;
            }
            return new Object[]{result};
        }
        return EMPTY_OBJECT_ARRAY;
    }

    protected PropertyDescriptor getPropertyDescriptor(Object bean, String property) throws IntrospectionException {
        if (bean == null) {
            return null;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getName().equals(property)) {
                return descriptors[i];
            }
            ++i;
        }
        return null;
    }

    public Object getValue(String name) {
        Object[] values = this.getValues(name = this.validateName(name));
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setValue(String name, Object value) {
        name = this.validateName(name);
        this.setValues(name, new Object[]{value});
    }

    public Object[] getValues(String name) {
        name = this.validateName(name);
        try {
            Object bean = this.getCurrentBean();
            if (bean == null) {
                return EMPTY_OBJECT_ARRAY;
            }
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc == null) {
                return EMPTY_OBJECT_ARRAY;
            }
            Method method = desc.getReadMethod();
            if (method == null) {
                return EMPTY_OBJECT_ARRAY;
            }
            Object result = method.invoke(bean, EMPTY_OBJECT_ARRAY);
            if (method.getReturnType().isArray()) {
                return (Object[])result;
            }
            return new Object[]{result};
        }
        catch (Exception e) {
            throw new ValidationException("Exception caught getting value for property \"" + name + "\"", e);
        }
    }

    public void setValues(String name, Object[] value) {
        name = this.validateName(name);
        Object[] param = null;
        try {
            if (value == null || value.length == 0) {
                return;
            }
            Object bean = this.getCurrentBean();
            if (bean == null) {
                return;
            }
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc == null) {
                return;
            }
            Method method = desc.getWriteMethod();
            if (method == null) {
                return;
            }
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1) {
                return;
            }
            if (paramTypes[0].isArray()) {
                param = (Object[])Array.newInstance(paramTypes[0].getComponentType(), value.length);
                System.arraycopy(value, 0, param, 0, value.length);
            } else {
                param = TypeConverter.asType(paramTypes[0], value[0]);
            }
            method.invoke(bean, new Object[]{param});
        }
        catch (Exception e) {
            throw new ValidationException("Exception caught setting value for property \"" + name + "\", value was \"" + param + "\" (type = " + (param == null ? "null" : param.getClass().getName()) + "\"", e);
        }
    }

    public int getSize() throws ModelControlException {
        return this.getBeans().length;
    }

    public void setSize(int value) throws ModelControlException {
        throw new ModelControlException("Cannot set the size of a " + this.getClass().getName());
    }

    public int getLocationOffset() {
        return this.locationOffset;
    }

    protected void setLocationOffset(int value) {
        this.locationOffset = value;
    }

    public int getLocation() throws ModelControlException {
        return this.getIndex();
    }

    public void setLocation(int location) throws ModelControlException {
        if (location > this.getBeans().length - 1) {
            throw new ModelControlException("Location is beyond the end of the current bean array (" + location + " > " + (this.getBeans().length - 1) + ")");
        }
        this.setIndex(location);
    }

    protected int getIndex() {
        return this.index;
    }

    protected void setIndex(int value) {
        this.index = value;
    }

    protected boolean checkIndex() {
        if (this.getBeans().length == 0) {
            this.setIndex(-1);
            this.setLocationOffset(0);
            return false;
        }
        if (this.getIndex() >= this.getBeans().length) {
            this.setIndex(this.getBeans().length - 1);
            return false;
        }
        if (this.getIndex() < this.getLocationOffset() && this.getBeans().length > this.getLocationOffset()) {
            this.setIndex(this.getLocationOffset());
            return false;
        }
        return true;
    }

    public Object getCurrentBean() {
        this.checkIndex();
        if (this.getIndex() != -1) {
            return this.getBeans()[this.getIndex()];
        }
        return null;
    }

    public void beforeFirst() throws ModelControlException {
        this.setIndex(this.getLocationOffset() - 1);
    }

    public boolean first() throws ModelControlException {
        this.setIndex(this.getLocationOffset());
        return this.checkIndex();
    }

    public boolean last() throws ModelControlException {
        this.setIndex(this.getBeans().length - 1);
        return this.checkIndex();
    }

    public boolean next() throws ModelControlException {
        this.setIndex(this.getLocation() + 1);
        return this.checkIndex();
    }

    public boolean previous() throws ModelControlException {
        this.setIndex(this.getLocation() - 1);
        return this.checkIndex();
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        if (context == null) {
            throw new IllegalArgumentException("Context passed to the execute() method cannot be null because it requires specification of an operation name");
        }
        if (context.getOperationName() == null) {
            throw new IllegalArgumentException("Context operation name cannot be null");
        }
        if (!context.getOperationName().equals("retrieve")) {
            throw new IllegalArgumentException("Unknown context operation name \"" + context.getOperationName() + "\"");
        }
        return this.retrieve(context);
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        if (!this.beansSetManually) {
            this.beans = this.findBeans();
        }
        if (context != null && context instanceof DatasetModelExecutionContext) {
            this.setLocationOffset(DatasetModelExecutionContextImpl.calculatePaginationOffset(this, (DatasetModelExecutionContext)context));
        }
        return null;
    }

    public void setFieldGroup(ModelFieldGroup group) {
        this.fieldGroup = group;
    }

    public ModelFieldGroup getFieldGroup() {
        return this.fieldGroup;
    }

    protected void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    protected Class getBeanClass() {
        return this.beanClass;
    }

    protected String validateName(String name) {
        BeanPropertyFieldDescriptor field;
        if (null == name || name.trim().length() == 0) {
            throw new IllegalArgumentException("The 'name' parameter cannot be null or blank");
        }
        BeanPropertyFieldDescriptor beanPropertyFieldDescriptor = field = null != this.getFieldGroup() ? (BeanPropertyFieldDescriptor)this.getFieldGroup().getFieldDescriptor(name) : null;
        if (null == field || null == field.getPropertyName() || field.getPropertyName().trim().length() == 0) {
            return name;
        }
        return field.getPropertyName();
    }

    static {
        UNDEFINED_ROW_INDEX = -1;
        BEAN_SCOPE_NONE = 0;
        BEAN_SCOPE_REQUEST = 1;
        BEAN_SCOPE_SESSION = 2;
        BEAN_SCOPE_APPLICATION = 4;
        BEAN_SCOPE_ANY = 7;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

