/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws.boot;

import com.sun.enterprise.appclient.jws.boot.ClassPathManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;

public class ClassPathManager16
extends ClassPathManager {
    private Class jnlpClassLoaderClass;
    private Method getJarFileMethod;

    protected ClassPathManager16(ClassLoader loader) {
        super(loader);
        try {
            this.prepareIntrospectionInfo();
        }
        catch (Throwable thr) {
            throw new RuntimeException(thr);
        }
    }

    private void prepareIntrospectionInfo() throws ClassNotFoundException, NoSuchMethodException {
        this.jnlpClassLoaderClass = this.getJNLPClassLoader().loadClass("com.sun.jnlp.JNLPClassLoader");
        this.getJarFileMethod = this.jnlpClassLoaderClass.getDeclaredMethod("getJarFile", URL.class);
        this.getJarFileMethod.setAccessible(true);
    }

    public ClassLoader getParentClassLoader() {
        return this.getJNLPClassLoader().getParent();
    }

    public File findContainingJar(URL resourceURL) throws IllegalArgumentException, URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException {
        URI resourceURI = resourceURL.toURI();
        String ssp = resourceURI.getSchemeSpecificPart();
        String jarOnlySSP = ssp.substring(0, ssp.indexOf(33));
        URL jarOnlyURL = new URL(jarOnlySSP).toURI().toURL();
        JarFile jarFile = (JarFile)this.getJarFileMethod.invoke((Object)this.getJNLPClassLoader(), jarOnlyURL);
        File f = new File(jarFile.getName());
        return f;
    }
}

