/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.HashMap;
import java.util.Map;

public class CreateMBeanCommand
extends GenericCommand {
    public static final String TARGET_OPTION = "target";
    public static final String NAME_OPTION = "name";
    public static final String OBJECT_NAME_OPTION = "objectname";
    public static final String ATTRIBUTES_OPTION = "attributes";
    public static final String ATTRIBUTE_DELIMITER = ":";
    public static final String ATTRIBUTE_VALUE_DELIMITER = "=";

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        Object[] paramsInfo = new Object[3];
        paramsInfo[0] = this.getOption(TARGET_OPTION);
        HashMap<String, String> mbeanParams = new HashMap<String, String>();
        if (this.getOption(NAME_OPTION) != null) {
            mbeanParams.put(NAME_OPTION, this.getOption(NAME_OPTION));
        }
        if (this.getOption(OBJECT_NAME_OPTION) != null) {
            mbeanParams.put("object-name", this.getOption(OBJECT_NAME_OPTION));
        }
        mbeanParams.put("impl-class-name", (String)this.getOperands().get(0));
        paramsInfo[1] = mbeanParams;
        paramsInfo[2] = this.getAttributesList(this.getOption(ATTRIBUTES_OPTION));
        return paramsInfo;
    }

    private Map getAttributesList(String attributesStr) throws CommandException, CommandValidationException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (attributesStr == null) {
            return attributes;
        }
        CLITokenizer attrTok = new CLITokenizer(attributesStr, ATTRIBUTE_DELIMITER);
        while (attrTok.hasMoreTokens()) {
            String nameAndvalue = attrTok.nextToken();
            CLITokenizer nameTok = new CLITokenizer(nameAndvalue, ATTRIBUTE_VALUE_DELIMITER);
            if (nameTok.countTokens() == 2) {
                attributes.put(nameTok.nextTokenWithoutEscapeAndQuoteChars(), nameTok.nextTokenWithoutEscapeAndQuoteChars());
                continue;
            }
            throw new CommandValidationException(this.getLocalizedString("InvalidAttributeSyntax"));
        }
        CLILogger.getInstance().printDebugMessage("Got the Attributes List : " + ((Object)attributes).toString());
        return attributes;
    }
}

