#from urlparse import urlparse
from Envy import networkmanager
from Envy import packagemanager
from Envy import ui
from Envy.packagemanager import HeadersException


import urllib
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *

class Network(QThread):
    
    def __init__(self, package, directory, parent=None):
        super(Network, self).__init__(parent)
        self.pkg = packagemanager.PkgManager(None, None)
        self.package = package
        self.directory = directory
        self.translation = ui.AbstractUI()
        
    
    def isConnected(self):
        return networkmanager.getConnectionStatus()
    
    def download(self, files, urls, directory, settext, callback):
        '''
        files = {file: url, file1: url2}
        
        settext = a function which sets the text of the label
        '''
        self.complete = 0
        os.chdir(directory)
        self.total = len(files)
        it = 0
        for file in files:
            url = urls[it]
            settext(it+1)#, total)
            
            try:
                
                urllib.urlretrieve(url, file, callback)
            except IOError:
                self.emit(SIGNAL("error(bool)"), 1)
                self.complete = 1
                return False
            it += 1
        self.emit(SIGNAL("complete(bool)"), 1)
        self.complete = 2
        #return True


    def run(self):
        '''
        use self.progressBar
        
        NOTE: if text is True multithreading won't be used
        
        '''
        
        if self.isConnected():
            files = []
            urls = []
            
            packages = []
            
            
            packages.append(self.package)
            dependencies = self.pkg.getDependencies(self.package)
            if dependencies:
                packages += dependencies
            
            for package in packages:
                url = self.pkg.getUrl(package).strip()
                urls.append(url)
                
                file = url[url.rfind('/')+1:].strip()
                files.append(file)#[file] = url
            
            self.download(files, urls, self.directory, self.updateLabel, self.callback)
            #return True

    def updateLabel(self, item):#, total):
        message = '%s %d/%d...' % (self.translation.string_package_download, item, self.total)
        self.emit(SIGNAL("started(QString)"), message)        
    
    def callback(self, transferred, blocksize, totalsize):
        if (totalsize != 0):
            fraction = (transferred * blocksize * 100 / totalsize)
            
            if fraction < 0: fraction = 0
            if fraction > 100: fraction = 100
        else:
            fraction = 0
        #self.updateUi(fraction)
        self.emit(SIGNAL("downloaded"), fraction)
