/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.webdav.internal.kernel.utils;

import java.util.Enumeration;
import java.util.Vector;

public class ExcludingEnumeration extends EnumerationFilter {

	protected Enumeration enum;
	protected Vector excludeList;
	protected Object next;
public ExcludingEnumeration(Enumeration enum, Vector excludeList) {

	super();

	this.enum = enum;
	this.excludeList = excludeList;

	getNextCandidate();
}
private void getNextCandidate() {

	while (enum.hasMoreElements()) {
		Object candidate = enum.nextElement();
		if (excludeList.indexOf(candidate) != -1) {
			next = candidate;
			return;
		}
	}

	next = null;
}
public boolean hasMoreElements() {

	return (next != null);
}
public Object nextElement() {

	Object answer = next;
	getNextCandidate();
	return answer;
}
}
