/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.webdav.internal.kernel.utils;

import java.util.Enumeration;

public abstract class EnumerationConverter extends EnumerationFilter {

	protected Enumeration sourceEnum;
public EnumerationConverter(Enumeration sourceEnum) {
	
	super();

	this.sourceEnum = sourceEnum;
}
public boolean hasMoreElements() {
	
	return sourceEnum.hasMoreElements();
}
// Subclasses should override ths method to convert the
// source enum objects to the new types.
public abstract Object nextElement();
}
