/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.target;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.RemoteTargetSyncElement;
import org.eclipse.team.internal.core.target.TargetProvider;

public class FTPRemoteSyncElement extends RemoteTargetSyncElement {

	/**
	 * Constructor for FTPRemoteSyncElement.
	 * @param provider
	 * @param local
	 * @param remote
	 */
	public FTPRemoteSyncElement(
		TargetProvider provider,
		IResource local,
		IRemoteTargetResource remote) {
		
		super(provider, local, remote);
	}

	/**
	 * @see org.eclipse.team.core.sync.RemoteSyncElement#create(boolean, IResource, IRemoteResource, IRemoteResource, Object)
	 */
	public IRemoteSyncElement create(
		boolean isThreeWay,
		IResource local,
		IRemoteResource base,
		IRemoteResource remote,
		Object data) {
		return new FTPRemoteSyncElement(getProvider(), local, (IRemoteTargetResource)remote);
	}


	/**
	 * @see org.eclipse.team.core.sync.LocalSyncElement#create(IResource, IRemoteResource, Object)
	 */
	public ILocalSyncElement create(
		IResource local,
		IRemoteResource base,
		Object data) {
		return new FTPRemoteSyncElement(getProvider(), local, (IRemoteTargetResource)base);
	}


	/**
	 * @see RemoteTargetSyncElement#isOutOfDate(IProgressMonitor)
	 */
	protected boolean isOutOfDate(IProgressMonitor monitor) {
		FTPTargetProvider provider = (FTPTargetProvider)getProvider();
		try {
			return ((FTPResourceState)provider.getState(getLocal(), (IRemoteTargetResource)getRemote())).wasOutOfDate(monitor);
		} catch (TeamException e) {
			return true; // who knows?
		}
	}


}

