/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.http.CommonsHttpMessageSender;
import org.codehaus.xfire.transport.http.HttpChannel;

public class OutMessageRequestEntity
implements RequestEntity {
    private OutMessage message = null;
    private MessageContext context;
    private static final Log log = LogFactory.getLog((Class)OutMessageRequestEntity.class);

    public OutMessageRequestEntity(OutMessage msg, MessageContext context) {
        this.message = msg;
        this.context = context;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (CommonsHttpMessageSender.isGzipRequestEnabled(this.context)) {
            out = new GZIPOutputStream(out);
        }
        try {
            Attachments atts = this.message.getAttachments();
            if (atts != null) {
                atts.write(out);
            } else {
                HttpChannel.writeWithoutAttachments(this.context, this.message, out);
            }
        }
        catch (XFireException e) {
            log.error((Object)"Couldn't send message.", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        out.close();
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return HttpChannel.getSoapMimeType(this.message, true);
    }
}

