/////////////////////////////////////////////////////////////////////////////
// Name:        VobListBox.h
// Purpose:     The list box to display information about streams in given VOB
// Author:      Alex Thuering
// Created:     03.05.2009
// RCS-ID:      $Id: VobListBox.h,v 1.3 2009/06/13 14:47:22 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef TITLE_LIST_BOX_H
#define TITLE_LIST_BOX_H

#include <wx/wx.h>
#include <wx/vlbox.h>
#include <wx/choice.h>
#include <wx/dynarray.h>
#include "DVD.h"

WX_DECLARE_OBJARRAY(wxRect, RectList);
WX_DECLARE_OBJARRAY(RectList, RectListOfList);
WX_DECLARE_OBJARRAY(wxArrayString, StringListOfList);
WX_DEFINE_ARRAY(wxChoice*, ChoiceList);

/**
 * The list box to display information about streams in given VOB.
 */
class VobListBox: public wxVListBox {
public:
	/**
	 * Constructor
	 */
	VobListBox(wxWindow* parent, wxWindowID id, Vob* vob, DVD* dvd);
	
	/**
	 * Returns the height of the specified item (in pixels)
	 */
	wxCoord OnMeasureItem(size_t n) const;
	
	/**
	 * Draws the item with the given index on the provided DC
	 */
	void OnDrawItem(wxDC& dc, const wxRect& rect, size_t n) const;
	
	/**
	 * Removes item with given index
	 */
	void RemoveItem(int index);
	
	/**
	 * Adds audio file to the vob
	 */
	void AddAudio(wxString filename);
	
	/**
	 * Adds subtitle file to the vob
	 */
	void AddSubtitle(wxString filename);
	
	/**
	 * Disables transcoding: sets Copy for all streams and disables choice controls
	 */
	void SetDoNotTranscode(bool value);
	
	/**
	 * Returns true if this vob contains audio files
	 */
	bool HasAudioFiles();
	
	/**
	 * Updates vob object with values from controls
	 */
	Vob* UpdateVob();
	
private:
	DVD* m_dvd;
	Vob* m_vob;
	StringListOfList m_info;
	RectListOfList m_infoRect;
	ChoiceList m_choiceList;
	wxBitmap m_videoImg;
	wxBitmap m_audioImg;
	wxBitmap m_subtitleImg;
	wxImage LoadFrame(const wxString& filename) const;
	wxBitmap Scale(wxImage image);
	void RefreshInfo();
	int AddInfo(const wxString& s, int n, wxDC& dc, int x, int y);
	int AddChoiceCtrl(wxArrayString formats, int selection, wxRect& rect, int itemY, int& choiceIdx);
};

#endif // TITLE_LIST_BOX_H
