/////////////////////////////////////////////////////////////////////////////
// Name:        Utils.h
// Purpose:     Miscellaneous utilities
// Author:      Alex Thuering
// Created:		06.04.2008
// RCS-ID:      $Id: Utils.h,v 1.1 2008/04/18 20:14:41 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_H
#define UTILS_H

#include <wxSVGXML/svgxml.h>

const wxString DATAFORMAT_MENU =  wxT("application/dvdstyler-menu");
const wxString DATAFORMAT_MENU_OBJECT =  wxT("application/dvdstyler-menu-object");

/**
 * Copies given xml node to the clipboard.
 * Data Format: application/dvdstyler
 */
void CopyXmlToClipboard(wxSvgXmlNode* node, wxString dataFormatId);
/**
 * Gets xml node from clipboard.
 * Data Format: application/dvdstyler
 */
bool GetXmlFromClipboard(wxString dataFormatId, wxSvgXmlDocument& doc);
/**
 * Gets text from clipboard.
 */
wxString GetTextFromClipboard();

#endif // UTILS_H
