/////////////////////////////////////////////////////////////////////////////
// Name:        MenuObject.h
// Purpose:     The class to store a DVD Menu Object
// Author:      Alex Thuering
// Created:	04.11.2006
// RCS-ID:      $Id: MenuObject.h,v 1.6 2009/01/02 12:01:52 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef MENU_OBJECT_H
#define MENU_OBJECT_H

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/dynarray.h>

class wxSvgXmlNode;
class wxSVGDocument;
class wxSVGElement;
class wxSVGUseElement;
class wxSVGSVGElement;

enum DVDFileType { DVDSTYLER_XML, DVDAUTHOR_XML, SPUMUX_XML };

enum MenuButtonState
{
  mbsNORMAL,
  mbsHIGHLIGHTED,
  mbsSELECTED
};

class Menu;

struct MenuObjectParam
{
  wxString name;
  wxString title;
  wxString type;
  wxString element; // id of element
  wxString attribute; // attribute name
  bool changeable; // changed if select the button
  wxColour normalColour;
  wxColour highlightedColour;
  wxColour selectedColour;
};

WX_DEFINE_ARRAY(MenuObjectParam*, MenuObjectParams);

class MenuAction
{
  public:
    MenuAction() {}
    MenuAction(wxString id): m_id(id) {}
    
    inline wxString GetId() { return m_id; }
    wxString GetAction(bool translate = false);
	
	inline bool HasCustomAction() { return m_action.length()>0; }
	inline int  GetActionTsi() { return m_actionTsi; }
	inline void	SetActionTsi(int value) { m_actionTsi = value; }
	inline int  GetActionPgci() { return m_actionPgci; }
	inline void	SetActionPgci(int value) { m_actionPgci = value; }
	inline int  GetActionChapter() { return m_actionChapter; }
	inline void	SetActionChapter(int value) { m_actionChapter = value; }
	inline wxString GetCustomAction() { return m_action; }
	inline void SetCustomAction(wxString action) { m_action = action; }
	
	wxSvgXmlNode* GetXML(DVDFileType type = DVDSTYLER_XML, bool button = false);
	bool PutXML(wxSvgXmlNode* node, bool button = false);
    
  protected:
    wxString m_id;
    wxString m_action;
	int m_actionTsi;
	int m_actionPgci;
	int m_actionChapter;
};

class MenuObject: public MenuAction
{
  public:
	MenuObject(Menu* menu, wxString fileName = wxT(""),
      int x = 0, int y = 0, wxString param = wxT(""));
	virtual ~MenuObject();
	
	inline bool IsButton() { return m_button; }
    
    inline wxString GetFileName() { return m_fileName; }
    inline wxString GetTitle() { return m_title; }
    
    int  GetX();
    void SetX(int value);
    int  GetY();
    void SetY(int value);
    int  GetWidth();
    void SetWidth(int value);
    int  GetHeight();
    void SetHeight(int value);
    
    inline wxRect GetBBox()
    { return wxRect(GetX(), GetY(), GetWidth(), GetHeight()); }
	
	inline bool IsDefaultSize() { return m_defaultSize; }
	inline void SetDefaultSize(bool value = true) { m_defaultSize = value; }
    void FixSize(int& width, int& height);
    void UpdateSize();
    
    int GetObjectParamsCount() { return m_params.Count(); }
    MenuObjectParam* GetObjectParam(int index) { return m_params[index]; }
    MenuObjectParam* GetObjectParam(wxString name);
    MenuObjectParam* GetInitParam();
    
    wxString GetParam(wxString name, wxString attrSuffix = wxEmptyString);
	void SetParam(wxString name, wxString value, wxString attrSuffix = wxEmptyString);
    int GetParamInt(wxString name);
	void SetParamInt(wxString name, int value);
	double GetParamDouble(wxString name);
	void SetParamDouble(wxString name, double value);
	wxFont GetParamFont(wxString name);
	void SetParamFont(wxString name, wxFont value);
	wxColour GetParamColour(wxString name, MenuButtonState state = mbsNORMAL);
	void SetParamColour(wxString name, wxColour value, MenuButtonState state = mbsNORMAL);
    
    void ToFront();
    void Forward();
    void Backward();
    void ToBack();
    bool IsFirst();
    bool IsLast();
    
	inline bool IsPlayAll() { return m_playAll; }
	inline void SetPlayAll(bool value) { m_playAll = value; }
	inline int  GetAudio() { return m_audio; }
	inline void	SetAudio(int value) { m_audio = value; }
	inline int  GetSubtitle() { return m_subtitle; }
	inline void	SetSubtitle(int value) { m_subtitle = value; }
	
	
	wxString GetDirection(int dir) { return m_direction[dir]; }
	void SetDirection(int dir, wxString value) { m_direction[dir] = value; }
	
	wxImage GetImage(int maxWidth, int maxHeight);
	
	virtual wxSvgXmlNode* GetXML(DVDFileType type = DVDSTYLER_XML,
      bool withSVG = false, int playAllRegister = -1);
	virtual bool PutXML(wxSvgXmlNode* node);
	
  protected:
	bool m_button;
    wxString m_fileName;
    wxString m_title;
    
	bool m_playAll;
	int m_audio;
	int m_subtitle;
	wxString m_direction[4]; // left, right, up, down button names
    
    MenuObjectParams m_params;
    wxString m_initParameter;
    
    bool m_defaultSize;
    wxString m_defaultSizeElement;
    int m_defaultSizeWidth;
    int m_defaultSizeHeight;
    
    wxString m_minSizeElement;
    int m_minSizeWidth;
    int m_minSizeHeight;
    
    wxSVGDocument* m_svg;
    wxSVGUseElement* m_use;
    wxSVGSVGElement* m_symbol;
    wxSVGSVGElement* AddSymol(wxString id, wxSVGElement* content);
    void AddUse(wxString id, int x, int y, int width, int height);
    
    bool Init(wxString filename, int x = 0, int y = 0, wxString param = wxT(""));
    bool LoadSVG(wxSVGDocument& svg, wxSvgXmlNode* node);
    wxString GenerateId(wxString prefix);
};

#endif // MENU_OBJECT_H
