/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PAVN.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushArgvNoQuotes(struct Cfg_Getopt *optstru, char **argv)

 *	Push an already broken up argument array, similiar to the argc/argv
 *	parameters of main(). It is considered that the startup code of
 *	the programs does not honor quotes. This, however, tends to loose the
 *	correct amount of spaces which were quoted.

ob(ject): cfgPushArgvNoQuotes
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Push an already broken-up command line (argc/argv)
he(ader files): 
lo(ng description): Push an already broken-up command line onto the
	input stack. Associated is a "read" function that assumes that
	the C startup code does not honor quotes
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pavn.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PAVN.C 1.4 1999/12/13 02:22:01 ska Exp ska $";
#endif

void cfgPushArgvNoQuotes(struct Cfg_Getopt * const optstru
 , const char * const * const argv)
{	DBG_ENTER("cfgPushArgvNoQuotes", Suppl_cmdline)
	cfg_pushArgv(optstru, argv, aF(cfg_rdArgv));
	DBG_EXIT
}
